/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.jndi;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    public static final String SYS_PROPERTY_PLACEHOLDER_PREFIX = "$sys{";
    public static final String ENV_VAR_PLACEHOLDER_PREFIX = "$env{";
    public static final String DYNAMIC_PROPERTY_PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    private static Log log = LogFactory.getLog(Utils.class);

    public static String resolveSystemProperty(String text) {
        int indexOfClosingBrace;
        String sysRefs = StringUtils.substringBetween((String)text, (String)SYS_PROPERTY_PLACEHOLDER_PREFIX, (String)PLACEHOLDER_SUFFIX);
        String envRefs = StringUtils.substringBetween((String)text, (String)ENV_VAR_PLACEHOLDER_PREFIX, (String)PLACEHOLDER_SUFFIX);
        if (sysRefs != null) {
            String property = System.getProperty(sysRefs);
            if (StringUtils.isNotEmpty((String)property)) {
                text = text.replaceAll(Pattern.quote(SYS_PROPERTY_PLACEHOLDER_PREFIX + sysRefs + PLACEHOLDER_SUFFIX), property);
            } else {
                log.error((Object)("System property is not available for " + sysRefs));
            }
            return text;
        }
        if (envRefs != null) {
            String resolvedValue = System.getenv(envRefs);
            if (StringUtils.isNotEmpty((String)resolvedValue)) {
                text = text.replaceAll(Pattern.quote(ENV_VAR_PLACEHOLDER_PREFIX + envRefs + PLACEHOLDER_SUFFIX), resolvedValue);
            } else {
                log.error((Object)("Environment variable is not available for " + envRefs));
            }
            return text;
        }
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf(DYNAMIC_PROPERTY_PLACEHOLDER_PREFIX) && (indexOfStartingChars = text.indexOf(DYNAMIC_PROPERTY_PLACEHOLDER_PREFIX)) != -1 && (indexOfClosingBrace = text.indexOf(PLACEHOLDER_SUFFIX)) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue == null) {
                propValue = System.getenv(sysProp);
            }
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!sysProp.equals("carbon.home") || propValue == null || !propValue.equals(".")) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }
}

