/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.pool;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.andes.pool.ReadWriteRunnable;

public class ReadWriteJobQueue
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    private final AtomicInteger _count = new AtomicInteger(0);
    private final ReentrantLock _takeLock = new ReentrantLock();
    private final Condition _notEmpty = this._takeLock.newCondition();
    private final ReentrantLock _putLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<ReadWriteRunnable> _readJobQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ReadWriteRunnable> _writeJobQueue = new ConcurrentLinkedQueue();

    @Override
    public Iterator<Runnable> iterator() {
        return new ReadWriteJobIterator();
    }

    @Override
    public int size() {
        return this._count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Runnable runnable) {
        ReadWriteRunnable job = (ReadWriteRunnable)runnable;
        ReentrantLock putLock = this._putLock;
        putLock.lock();
        try {
            if (job.isRead()) {
                this._readJobQueue.offer(job);
            } else {
                this._writeJobQueue.offer(job);
            }
            if (this._count.getAndIncrement() == 0) {
                this._takeLock.lock();
                try {
                    this._notEmpty.signal();
                }
                finally {
                    this._takeLock.unlock();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            putLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Runnable runnable) throws InterruptedException {
        block8: {
            ReadWriteRunnable job = (ReadWriteRunnable)runnable;
            ReentrantLock putLock = this._putLock;
            putLock.lock();
            try {
                if (job.isRead()) {
                    this._readJobQueue.offer(job);
                } else {
                    this._writeJobQueue.offer(job);
                }
                if (this._count.getAndIncrement() != 0) break block8;
                this._takeLock.lock();
                try {
                    this._notEmpty.signal();
                }
                finally {
                    this._takeLock.unlock();
                }
            }
            finally {
                putLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Runnable runnable, long timeout, TimeUnit unit) throws InterruptedException {
        ReadWriteRunnable job = (ReadWriteRunnable)runnable;
        ReentrantLock putLock = this._putLock;
        putLock.lock();
        try {
            if (job.isRead()) {
                this._readJobQueue.offer(job);
            } else {
                this._writeJobQueue.offer(job);
            }
            if (this._count.getAndIncrement() == 0) {
                this._takeLock.lock();
                try {
                    this._notEmpty.signal();
                }
                finally {
                    this._takeLock.unlock();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            putLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable take() throws InterruptedException {
        ReentrantLock takeLock = this._takeLock;
        takeLock.lockInterruptibly();
        try {
            int c;
            try {
                while (this._count.get() == 0) {
                    this._notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this._notEmpty.signal();
                throw ie;
            }
            ReadWriteRunnable job = this._writeJobQueue.poll();
            if (job == null) {
                job = this._readJobQueue.poll();
            }
            if ((c = this._count.getAndDecrement()) > 1) {
                this._notEmpty.signal();
            }
            ReadWriteRunnable readWriteRunnable = job;
            return readWriteRunnable;
        }
        finally {
            takeLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Runnable> c) {
        int total = 0;
        this._putLock.lock();
        this._takeLock.lock();
        try {
            ReadWriteRunnable job;
            while ((job = this._writeJobQueue.peek()) != null) {
                c.add(job);
                this._writeJobQueue.poll();
                this._count.decrementAndGet();
                ++total;
            }
            while ((job = this._readJobQueue.peek()) != null) {
                c.add(job);
                this._readJobQueue.poll();
                this._count.decrementAndGet();
                ++total;
            }
        }
        finally {
            this._takeLock.unlock();
            this._putLock.unlock();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        int total;
        this._putLock.lock();
        this._takeLock.lock();
        try {
            ReadWriteRunnable job;
            for (total = 0; total <= maxElements && (job = this._writeJobQueue.peek()) != null; ++total) {
                c.add(job);
                this._writeJobQueue.poll();
                this._count.decrementAndGet();
            }
            while (total <= maxElements && (job = this._readJobQueue.peek()) != null) {
                c.add(job);
                this._readJobQueue.poll();
                this._count.decrementAndGet();
                ++total;
            }
        }
        finally {
            this._takeLock.unlock();
            this._putLock.unlock();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable poll() {
        ReentrantLock takeLock = this._takeLock;
        takeLock.lock();
        try {
            if (this._count.get() > 0) {
                ReadWriteRunnable job = this._writeJobQueue.poll();
                if (job == null) {
                    job = this._readJobQueue.poll();
                }
                this._count.decrementAndGet();
                ReadWriteRunnable readWriteRunnable = job;
                return readWriteRunnable;
            }
            Runnable runnable = null;
            return runnable;
        }
        finally {
            takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable peek() {
        ReentrantLock takeLock = this._takeLock;
        takeLock.lock();
        try {
            ReadWriteRunnable job = this._writeJobQueue.peek();
            if (job == null) {
                job = this._readJobQueue.peek();
            }
            ReadWriteRunnable readWriteRunnable = job;
            return readWriteRunnable;
        }
        finally {
            takeLock.unlock();
        }
    }

    private class ReadWriteJobIterator
    implements Iterator<Runnable> {
        private boolean _onReads;
        private Iterator<ReadWriteRunnable> _iter;

        private ReadWriteJobIterator() {
            this._iter = ReadWriteJobQueue.this._writeJobQueue.iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this._iter.hasNext()) {
                if (this._onReads) {
                    this._iter = ReadWriteJobQueue.this._readJobQueue.iterator();
                    this._onReads = true;
                    return this._iter.hasNext();
                }
                return false;
            }
            return true;
        }

        @Override
        public Runnable next() {
            if (this._iter.hasNext()) {
                return this._iter.next();
            }
            return null;
        }

        @Override
        public void remove() {
            ReadWriteJobQueue.this._takeLock.lock();
            try {
                this._iter.remove();
                ReadWriteJobQueue.this._count.decrementAndGet();
            }
            finally {
                ReadWriteJobQueue.this._takeLock.unlock();
            }
        }
    }
}

