/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.filter.codec.textline;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.wso2.org.apache.mina.common.ByteBuffer;
import org.wso2.org.apache.mina.common.IoSession;
import org.wso2.org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.wso2.org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.wso2.org.apache.mina.filter.codec.textline.LineDelimiter;

public class TextLineEncoder
extends ProtocolEncoderAdapter {
    private static final String ENCODER = TextLineEncoder.class.getName() + ".encoder";
    private final Charset charset;
    private final LineDelimiter delimiter;
    private int maxLineLength = Integer.MAX_VALUE;

    public TextLineEncoder() {
        this(Charset.defaultCharset(), LineDelimiter.UNIX);
    }

    public TextLineEncoder(LineDelimiter delimiter) {
        this(Charset.defaultCharset(), delimiter);
    }

    public TextLineEncoder(Charset charset) {
        this(charset, LineDelimiter.UNIX);
    }

    public TextLineEncoder(Charset charset, LineDelimiter delimiter) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter");
        }
        if (LineDelimiter.AUTO.equals(delimiter)) {
            throw new IllegalArgumentException("AUTO delimiter is not allowed for encoder.");
        }
        this.charset = charset;
        this.delimiter = delimiter;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + maxLineLength);
        }
        this.maxLineLength = maxLineLength;
    }

    @Override
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        CharsetEncoder encoder = (CharsetEncoder)session.getAttribute(ENCODER);
        if (encoder == null) {
            encoder = this.charset.newEncoder();
            session.setAttribute(ENCODER, encoder);
        }
        String value = message.toString();
        ByteBuffer buf = ByteBuffer.allocate(value.length()).setAutoExpand(true);
        buf.putString(value, encoder);
        if (buf.position() > this.maxLineLength) {
            throw new IllegalArgumentException("Line length: " + buf.position());
        }
        buf.putString(this.delimiter.getValue(), encoder);
        buf.flip();
        out.write(buf);
    }

    public void dispose() throws Exception {
    }
}

