/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.handler.demux;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.org.apache.mina.common.IoHandlerAdapter;
import org.wso2.org.apache.mina.common.IoSession;
import org.wso2.org.apache.mina.handler.demux.MessageHandler;
import org.wso2.org.apache.mina.handler.demux.UnknownMessageTypeException;
import org.wso2.org.apache.mina.util.IdentityHashSet;

public class DemuxingIoHandler
extends IoHandlerAdapter {
    private final Map<Class, MessageHandler> findHandlerCache = new ConcurrentHashMap<Class, MessageHandler>();
    private final Map<Class, MessageHandler> type2handler = new ConcurrentHashMap<Class, MessageHandler>();

    public <E> MessageHandler<? super E> addMessageHandler(Class<E> type, MessageHandler<? super E> handler) {
        this.findHandlerCache.clear();
        return this.type2handler.put(type, handler);
    }

    public <E> MessageHandler<? super E> removeMessageHandler(Class<E> type) {
        this.findHandlerCache.clear();
        return this.type2handler.remove(type);
    }

    public <E> MessageHandler<? super E> getMessageHandler(Class<E> type) {
        return this.type2handler.get(type);
    }

    public Map<Class, MessageHandler> getMessageHandlerMap() {
        return Collections.unmodifiableMap(this.type2handler);
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        MessageHandler<Object> handler = this.findHandler(message.getClass());
        if (handler == null) {
            throw new UnknownMessageTypeException("No message handler found for message: " + message);
        }
        handler.messageReceived(session, message);
    }

    protected MessageHandler<Object> findHandler(Class type) {
        return this.findHandler(type, null);
    }

    private MessageHandler<Object> findHandler(Class type, Set<Class> triedClasses) {
        Class superclass;
        MessageHandler handler = null;
        if (triedClasses != null && triedClasses.contains(type)) {
            return null;
        }
        handler = this.findHandlerCache.get(type);
        if (handler != null) {
            return handler;
        }
        handler = this.type2handler.get(type);
        if (handler == null) {
            if (triedClasses == null) {
                triedClasses = new IdentityHashSet<Class>();
            }
            triedClasses.add(type);
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length && (handler = this.findHandler(interfaces[i], triedClasses)) == null; ++i) {
            }
        }
        if (handler == null && (superclass = type.getSuperclass()) != null) {
            handler = this.findHandler(superclass);
        }
        if (handler != null) {
            this.findHandlerCache.put(type, handler);
        }
        return handler;
    }
}

