/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.wso2.andes.client.XASession_9_1;

public class XaJmsSession
implements Session,
QueueSession,
TopicSession {
    private final XASession_9_1 session;
    private boolean closed = false;

    public XaJmsSession(XASession_9_1 session) {
        this.session = session;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkNotClosed();
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkNotClosed();
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.checkNotClosed();
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkNotClosed();
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkNotClosed();
        return this.session.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkNotClosed();
        return this.session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkNotClosed();
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        this.checkNotClosed();
        return this.session.createTextMessage(s);
    }

    public boolean getTransacted() throws JMSException {
        this.checkNotClosed();
        return this.session.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkNotClosed();
        return this.session.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.checkNotClosed();
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.checkNotClosed();
        this.session.rollback();
    }

    public void close() throws JMSException {
        this.closed = true;
    }

    public void recover() throws JMSException {
        this.checkNotClosed();
        this.session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkNotClosed();
        return this.session.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkNotClosed();
        this.session.setMessageListener(messageListener);
    }

    public void run() {
        this.session.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkNotClosed();
        return this.session.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkNotClosed();
        return this.session.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String s) throws JMSException {
        this.checkNotClosed();
        return this.session.createConsumer(destination, s);
    }

    public MessageConsumer createConsumer(Destination destination, String s, boolean b) throws JMSException {
        this.checkNotClosed();
        return this.session.createConsumer(destination, s, b);
    }

    public Queue createQueue(String s) throws JMSException {
        this.checkNotClosed();
        return this.session.createQueue(s);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkNotClosed();
        return this.session.createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String s) throws JMSException {
        this.checkNotClosed();
        return this.session.createReceiver(queue, s);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkNotClosed();
        return this.session.createSender(queue);
    }

    public Topic createTopic(String s) throws JMSException {
        this.checkNotClosed();
        return this.session.createTopic(s);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkNotClosed();
        return this.session.createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String s, boolean b) throws JMSException {
        this.checkNotClosed();
        return this.session.createSubscriber(topic, s, b);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s) throws JMSException {
        this.checkNotClosed();
        return this.session.createDurableSubscriber(topic, s);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String s, String s1, boolean b) throws JMSException {
        this.checkNotClosed();
        return this.session.createDurableSubscriber(topic, s, s1, b);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkNotClosed();
        return this.session.createPublisher(topic);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkNotClosed();
        return this.session.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String s) throws JMSException {
        this.checkNotClosed();
        return this.session.createBrowser(queue, s);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkNotClosed();
        return this.session.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkNotClosed();
        return this.session.createTemporaryTopic();
    }

    public void unsubscribe(String s) throws JMSException {
        this.checkNotClosed();
        this.session.unsubscribe(s);
    }

    private void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Session has been closed");
        }
    }
}

