/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.common;

import java.net.SocketAddress;
import org.wso2.org.apache.mina.common.IdleStatus;
import org.wso2.org.apache.mina.common.IoFilterChain;
import org.wso2.org.apache.mina.common.IoFutureListener;
import org.wso2.org.apache.mina.common.IoSession;
import org.wso2.org.apache.mina.common.WriteFuture;

public interface IoFilter {
    public void init() throws Exception;

    public void destroy() throws Exception;

    public void onPreAdd(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void onPostAdd(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void onPreRemove(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void onPostRemove(IoFilterChain var1, String var2, NextFilter var3) throws Exception;

    public void sessionCreated(NextFilter var1, IoSession var2) throws Exception;

    public void sessionOpened(NextFilter var1, IoSession var2) throws Exception;

    public void sessionClosed(NextFilter var1, IoSession var2) throws Exception;

    public void sessionIdle(NextFilter var1, IoSession var2, IdleStatus var3) throws Exception;

    public void exceptionCaught(NextFilter var1, IoSession var2, Throwable var3) throws Exception;

    public void messageReceived(NextFilter var1, IoSession var2, Object var3) throws Exception;

    public void messageSent(NextFilter var1, IoSession var2, Object var3) throws Exception;

    public void filterClose(NextFilter var1, IoSession var2) throws Exception;

    public void filterWrite(NextFilter var1, IoSession var2, WriteRequest var3) throws Exception;

    public static class WriteRequest {
        private static final WriteFuture UNUSED_FUTURE = new WriteFuture(){

            @Override
            public boolean isWritten() {
                return false;
            }

            @Override
            public void setWritten(boolean written) {
            }

            @Override
            public IoSession getSession() {
                return null;
            }

            @Override
            public void join() {
            }

            @Override
            public boolean join(long timeoutInMillis) {
                return true;
            }

            @Override
            public boolean isReady() {
                return true;
            }

            @Override
            public void addListener(IoFutureListener listener) {
                throw new IllegalStateException("You can't add a listener to a dummy future.");
            }

            @Override
            public void removeListener(IoFutureListener listener) {
                throw new IllegalStateException("You can't add a listener to a dummy future.");
            }

            @Override
            public Object getLock() {
                return this;
            }
        };
        private final Object message;
        private final WriteFuture future;
        private final SocketAddress destination;

        public WriteRequest(Object message) {
            this(message, null, null);
        }

        public WriteRequest(Object message, WriteFuture future) {
            this(message, future, null);
        }

        public WriteRequest(Object message, WriteFuture future, SocketAddress destination) {
            if (message == null) {
                throw new NullPointerException("message");
            }
            if (future == null) {
                future = UNUSED_FUTURE;
            }
            this.message = message;
            this.future = future;
            this.destination = destination;
        }

        public WriteFuture getFuture() {
            return this.future;
        }

        public Object getMessage() {
            return this.message;
        }

        public SocketAddress getDestination() {
            return this.destination;
        }

        public String toString() {
            return this.message.toString();
        }
    }

    public static interface NextFilter {
        public void sessionCreated(IoSession var1);

        public void sessionOpened(IoSession var1);

        public void sessionClosed(IoSession var1);

        public void sessionIdle(IoSession var1, IdleStatus var2);

        public void exceptionCaught(IoSession var1, Throwable var2);

        public void messageReceived(IoSession var1, Object var2);

        public void messageSent(IoSession var1, Object var2);

        public void filterWrite(IoSession var1, WriteRequest var2);

        public void filterClose(IoSession var1);
    }
}

