/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.common;

import java.nio.ByteOrder;
import org.wso2.org.apache.mina.common.ByteBuffer;
import org.wso2.org.apache.mina.common.ByteBufferAllocator;
import org.wso2.org.apache.mina.common.support.BaseByteBuffer;
import org.wso2.org.apache.mina.util.ExpiringStack;

public class PooledByteBufferAllocator
implements ByteBufferAllocator {
    private static final int MINIMUM_CAPACITY = 1;
    private static int threadId = 0;
    private final Expirer expirer;
    private final ExpiringStack[] heapBufferStacks = new ExpiringStack[]{new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack()};
    private final ExpiringStack[] directBufferStacks = new ExpiringStack[]{new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack()};
    private int timeout;
    private boolean disposed;

    public PooledByteBufferAllocator() {
        this(60);
    }

    public PooledByteBufferAllocator(int timeout) {
        this.setTimeout(timeout);
        this.expirer = new Expirer();
        this.expirer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ExpiringStack expiringStack;
        ExpiringStack stack;
        int i;
        if (this == ByteBuffer.getAllocator()) {
            throw new IllegalStateException("This allocator is in use.");
        }
        this.expirer.shutdown();
        for (i = this.directBufferStacks.length - 1; i >= 0; --i) {
            expiringStack = stack = this.directBufferStacks[i];
            synchronized (expiringStack) {
                stack.clear();
                continue;
            }
        }
        for (i = this.heapBufferStacks.length - 1; i >= 0; --i) {
            expiringStack = stack = this.heapBufferStacks[i];
            synchronized (expiringStack) {
                stack.clear();
                continue;
            }
        }
        this.disposed = true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getTimeoutMillis() {
        return (long)this.timeout * 1000L;
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            timeout = 0;
        }
        this.timeout = timeout;
        if (timeout > 0) {
            // empty if block
        }
    }

    @Override
    public ByteBuffer allocate(int capacity, boolean direct) {
        this.ensureNotDisposed();
        UnexpandableByteBuffer ubb = this.allocate0(capacity, direct);
        PooledByteBuffer buf = this.allocateContainer();
        buf.init(ubb, true);
        return buf;
    }

    private PooledByteBuffer allocateContainer() {
        return new PooledByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnexpandableByteBuffer allocate0(int capacity, boolean direct) {
        UnexpandableByteBuffer buf;
        ExpiringStack stack;
        ExpiringStack[] bufferStacks = direct ? this.directBufferStacks : this.heapBufferStacks;
        int idx = this.getBufferStackIndex(bufferStacks, capacity);
        ExpiringStack expiringStack = stack = bufferStacks[idx];
        synchronized (expiringStack) {
            buf = (UnexpandableByteBuffer)stack.pop();
        }
        if (buf == null) {
            java.nio.ByteBuffer nioBuf = direct ? java.nio.ByteBuffer.allocateDirect(1 << idx) : java.nio.ByteBuffer.allocate(1 << idx);
            buf = new UnexpandableByteBuffer(nioBuf);
        } else {
            java.nio.ByteBuffer b = buf.buf();
            b.clear();
            int max = b.remaining();
            for (int i = 0; i < max; ++i) {
                b.put((byte)0);
            }
        }
        buf.init();
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release0(UnexpandableByteBuffer buf) {
        ExpiringStack stack;
        ExpiringStack[] bufferStacks = buf.buf().isDirect() ? this.directBufferStacks : this.heapBufferStacks;
        ExpiringStack expiringStack = stack = bufferStacks[this.getBufferStackIndex(bufferStacks, buf.buf().capacity())];
        synchronized (expiringStack) {
            stack.push(buf);
        }
    }

    @Override
    public ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        this.ensureNotDisposed();
        PooledByteBuffer buf = this.allocateContainer();
        buf.init(new UnexpandableByteBuffer(nioBuffer), false);
        buf.buf.init();
        buf.setPooled(false);
        return buf;
    }

    private int getBufferStackIndex(ExpiringStack[] bufferStacks, int size) {
        int stackIdx = 0;
        for (int targetSize = 1; size > targetSize; targetSize <<= 1) {
            if (++stackIdx < bufferStacks.length) continue;
            throw new IllegalArgumentException("Buffer size is too big: " + size);
        }
        return stackIdx;
    }

    private void ensureNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("This allocator is disposed already.");
        }
    }

    private class UnexpandableByteBuffer {
        private final java.nio.ByteBuffer buf;
        private final UnexpandableByteBuffer parentBuf;
        private int refCount;
        private boolean pooled;

        protected UnexpandableByteBuffer(java.nio.ByteBuffer buf) {
            this.buf = buf;
            this.parentBuf = null;
        }

        protected UnexpandableByteBuffer(java.nio.ByteBuffer buf, UnexpandableByteBuffer parentBuf) {
            parentBuf.acquire();
            this.buf = buf;
            this.parentBuf = parentBuf;
        }

        public void init() {
            this.refCount = 1;
            this.pooled = true;
        }

        public synchronized void acquire() {
            if (this.isDerived()) {
                this.parentBuf.acquire();
                return;
            }
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.isDerived()) {
                this.parentBuf.release();
                return;
            }
            UnexpandableByteBuffer unexpandableByteBuffer = this;
            synchronized (unexpandableByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            if (PooledByteBufferAllocator.this.disposed) {
                return;
            }
            if (this.pooled) {
                if (this.parentBuf != null) {
                    PooledByteBufferAllocator.this.release0(this.parentBuf);
                } else {
                    PooledByteBufferAllocator.this.release0(this);
                }
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isPooled() {
            return this.pooled;
        }

        public void setPooled(boolean pooled) {
            this.pooled = pooled;
        }

        public boolean isDerived() {
            return this.parentBuf != null;
        }
    }

    private class PooledByteBuffer
    extends BaseByteBuffer {
        private UnexpandableByteBuffer buf;
        private int refCount = 1;

        protected PooledByteBuffer() {
        }

        public synchronized void init(UnexpandableByteBuffer buf, boolean clear) {
            this.buf = buf;
            if (clear) {
                buf.buf().clear();
            }
            buf.buf().order(ByteOrder.BIG_ENDIAN);
            this.setAutoExpand(false);
            this.refCount = 1;
        }

        @Override
        public synchronized void acquire() {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            PooledByteBuffer pooledByteBuffer = this;
            synchronized (pooledByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            if (PooledByteBufferAllocator.this.disposed) {
                return;
            }
            this.buf.release();
        }

        @Override
        public java.nio.ByteBuffer buf() {
            return this.buf.buf();
        }

        @Override
        public boolean isPooled() {
            return this.buf.isPooled();
        }

        @Override
        public void setPooled(boolean pooled) {
            this.buf.setPooled(pooled);
        }

        @Override
        public ByteBuffer duplicate() {
            PooledByteBuffer newBuf = PooledByteBufferAllocator.this.allocateContainer();
            newBuf.init(new UnexpandableByteBuffer(this.buf().duplicate(), this.buf), false);
            return newBuf;
        }

        @Override
        public ByteBuffer slice() {
            PooledByteBuffer newBuf = PooledByteBufferAllocator.this.allocateContainer();
            newBuf.init(new UnexpandableByteBuffer(this.buf().slice(), this.buf), false);
            return newBuf;
        }

        @Override
        public ByteBuffer asReadOnlyBuffer() {
            PooledByteBuffer newBuf = PooledByteBufferAllocator.this.allocateContainer();
            newBuf.init(new UnexpandableByteBuffer(this.buf().asReadOnlyBuffer(), this.buf), false);
            return newBuf;
        }

        @Override
        public byte[] array() {
            return this.buf().array();
        }

        @Override
        public int arrayOffset() {
            return this.buf().arrayOffset();
        }

        @Override
        protected void capacity0(int requestedCapacity) {
            UnexpandableByteBuffer newBuf;
            int newCapacity;
            if (this.buf.isDerived()) {
                throw new IllegalStateException("Derived buffers cannot be expanded.");
            }
            for (newCapacity = 1; newCapacity < requestedCapacity; newCapacity <<= 1) {
            }
            UnexpandableByteBuffer oldBuf = this.buf;
            boolean direct = this.isDirect();
            try {
                newBuf = PooledByteBufferAllocator.this.allocate0(newCapacity, direct);
            }
            catch (OutOfMemoryError e) {
                if (direct) {
                    newBuf = PooledByteBufferAllocator.this.allocate0(newCapacity, false);
                }
                throw e;
            }
            newBuf.buf().clear();
            oldBuf.buf().clear();
            newBuf.buf().put(oldBuf.buf());
            this.buf = newBuf;
            oldBuf.release();
        }
    }

    private class Expirer
    extends Thread {
        private boolean timeToStop;

        Expirer() {
            super("PooledByteBufferExpirer-" + threadId++);
            this.setDaemon(true);
        }

        public void shutdown() {
            this.timeToStop = true;
            this.interrupt();
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.timeToStop) {
                ExpiringStack expiringStack;
                ExpiringStack stack;
                int i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long timeout = PooledByteBufferAllocator.this.getTimeoutMillis();
                if (timeout <= 0L) continue;
                long expirationTime = System.currentTimeMillis() - timeout;
                for (i = PooledByteBufferAllocator.this.directBufferStacks.length - 1; i >= 0; --i) {
                    expiringStack = stack = PooledByteBufferAllocator.this.directBufferStacks[i];
                    synchronized (expiringStack) {
                        stack.expireBefore(expirationTime);
                        continue;
                    }
                }
                for (i = PooledByteBufferAllocator.this.heapBufferStacks.length - 1; i >= 0; --i) {
                    expiringStack = stack = PooledByteBufferAllocator.this.heapBufferStacks[i];
                    synchronized (expiringStack) {
                        stack.expireBefore(expirationTime);
                        continue;
                    }
                }
            }
        }
    }
}

