/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.client.message.JMSBytesMessage;

public class MessageConverter {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private AbstractJMSMessage _newMessage;

    public MessageConverter(AbstractJMSMessage message) throws JMSException {
        this._newMessage = message;
    }

    public MessageConverter(AMQSession session, BytesMessage bytesMessage) throws JMSException {
        int len;
        bytesMessage.reset();
        JMSBytesMessage nativeMsg = (JMSBytesMessage)session.createBytesMessage();
        byte[] buf = new byte[1024];
        while ((len = bytesMessage.readBytes(buf)) != -1) {
            nativeMsg.writeBytes(buf, 0, len);
        }
        this._newMessage = nativeMsg;
        this.setMessageProperties((Message)bytesMessage);
    }

    public MessageConverter(AMQSession session, MapMessage message) throws JMSException {
        MapMessage nativeMessage = session.createMapMessage();
        Enumeration mapNames = message.getMapNames();
        while (mapNames.hasMoreElements()) {
            String name = (String)mapNames.nextElement();
            nativeMessage.setObject(name, message.getObject(name));
        }
        this._newMessage = (AbstractJMSMessage)nativeMessage;
        this.setMessageProperties((Message)message);
    }

    public MessageConverter(AMQSession session, ObjectMessage origMessage) throws JMSException {
        ObjectMessage nativeMessage = session.createObjectMessage();
        nativeMessage.setObject(origMessage.getObject());
        this._newMessage = (AbstractJMSMessage)nativeMessage;
        this.setMessageProperties((Message)origMessage);
    }

    public MessageConverter(AMQSession session, TextMessage message) throws JMSException {
        TextMessage nativeMessage = session.createTextMessage();
        nativeMessage.setText(message.getText());
        this._newMessage = (AbstractJMSMessage)nativeMessage;
        this.setMessageProperties((Message)message);
    }

    public MessageConverter(AMQSession session, StreamMessage message) throws JMSException {
        StreamMessage nativeMessage = session.createStreamMessage();
        try {
            message.reset();
            while (true) {
                nativeMessage.writeObject(message.readObject());
            }
        }
        catch (MessageEOFException messageEOFException) {
            this._newMessage = (AbstractJMSMessage)nativeMessage;
            this.setMessageProperties((Message)message);
            return;
        }
    }

    public MessageConverter(AMQSession session, Message message) throws JMSException {
        Message nativeMessage = session.createMessage();
        this._newMessage = (AbstractJMSMessage)nativeMessage;
        this.setMessageProperties(message);
    }

    public AbstractJMSMessage getConvertedMessage() {
        return this._newMessage;
    }

    protected void setMessageProperties(Message message) throws JMSException {
        this.setNonJMSProperties(message);
        this.setJMSProperties(message);
    }

    protected void setNonJMSProperties(Message message) throws JMSException {
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = String.valueOf(propertyNames.nextElement());
            if (propertyName.startsWith("JMSX_")) continue;
            Object value = message.getObjectProperty(propertyName);
            this._newMessage.setObjectProperty(propertyName, value);
        }
    }

    protected void setJMSProperties(Message message) throws JMSException {
        this._newMessage.setJMSDeliveryMode(message.getJMSDeliveryMode());
        if (message.getJMSReplyTo() != null) {
            this._newMessage.setJMSReplyTo(message.getJMSReplyTo());
        }
        this._newMessage.setJMSType(message.getJMSType());
        this._newMessage.setJMSCorrelationID(message.getJMSCorrelationID());
    }
}

