/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.EncodableAMQDataBlock;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class SmallCompositeAMQDataBlock
extends AMQDataBlock
implements EncodableAMQDataBlock {
    private AMQDataBlock _firstFrame;
    private AMQDataBlock _block;

    public SmallCompositeAMQDataBlock(AMQDataBlock block) {
        this._block = block;
    }

    public SmallCompositeAMQDataBlock(AMQDataBlock encodedBlock, AMQDataBlock block) {
        this(block);
        this._firstFrame = encodedBlock;
    }

    public AMQDataBlock getBlock() {
        return this._block;
    }

    public AMQDataBlock getFirstFrame() {
        return this._firstFrame;
    }

    @Override
    public long getSize() {
        long frameSize = this._block.getSize();
        if (this._firstFrame != null) {
            frameSize += this._firstFrame.getSize();
        }
        return frameSize;
    }

    @Override
    public void writePayload(ByteBuffer buffer) {
        if (this._firstFrame != null) {
            this._firstFrame.writePayload(buffer);
        }
        this._block.writePayload(buffer);
    }

    public String toString() {
        if (this._block == null) {
            return "No blocks contained in composite frame";
        }
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append("{encodedBlock=").append(this._firstFrame);
        buf.append(" _block=[").append(this._block.toString()).append("]");
        buf.append("}");
        return buf.toString();
    }
}

