/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQConnectionURL;
import org.wso2.andes.client.AMQQueue;
import org.wso2.andes.client.AMQTopic;
import org.wso2.andes.client.SSLConfiguration;
import org.wso2.andes.jms.Connection;
import org.wso2.andes.jms.ConnectionListener;
import org.wso2.andes.jms.ConnectionURL;
import org.wso2.andes.url.AMQBindingURL;
import org.wso2.andes.url.URLSyntaxException;

public class AMQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
ObjectFactory,
Referenceable {
    private static final Logger logger = LoggerFactory.getLogger(AMQConnectionFactory.class);
    private String _host;
    private int _port;
    private String _defaultUsername;
    private String _defaultPassword;
    private String _virtualPath;
    protected ConnectionURL _connectionDetails;
    protected SSLConfiguration _sslConfig;
    private ConnectionListener connectionListener = null;
    private ThreadLocal<Boolean> removeBURL = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(AMQConnectionFactory.class);

    public AMQConnectionFactory() {
    }

    public AMQConnectionFactory(String url) throws URLSyntaxException {
        this._connectionDetails = new AMQConnectionURL(url);
    }

    public AMQConnectionFactory(ConnectionURL url) {
        this._connectionDetails = url;
    }

    public AMQConnectionFactory(String broker, String username, String password, String clientName, String virtualHost) throws URLSyntaxException {
        this(new AMQConnectionURL("amqp://" + username + ":" + password + "@" + clientName + "/" + virtualHost + "?brokerlist='" + broker + "'"));
    }

    public AMQConnectionFactory(String host, int port, String virtualPath) {
        this(host, port, "guest", "guest", virtualPath);
    }

    public AMQConnectionFactory(String host, int port, String defaultUsername, String defaultPassword, String virtualPath) {
        this._host = host;
        this._port = port;
        this._defaultUsername = defaultUsername;
        this._defaultPassword = defaultPassword;
        this._virtualPath = virtualPath;
    }

    public final String getDefaultPassword(String password) {
        if (this._connectionDetails != null) {
            return this._connectionDetails.getPassword();
        }
        return this._defaultPassword;
    }

    public final void setDefaultPassword(String password) {
        if (this._connectionDetails != null) {
            this._connectionDetails.setPassword(password);
        }
        this._defaultPassword = password;
    }

    public final SSLConfiguration getSSLConfiguration() {
        return this._sslConfig;
    }

    public final void setSSLConfiguration(SSLConfiguration sslConfig) {
        this._sslConfig = sslConfig;
    }

    public final String getDefaultUsername(String password) {
        if (this._connectionDetails != null) {
            return this._connectionDetails.getUsername();
        }
        return this._defaultUsername;
    }

    public final void setDefaultUsername(String username) {
        if (this._connectionDetails != null) {
            this._connectionDetails.setUsername(username);
        }
        this._defaultUsername = username;
    }

    public final String getHost() {
        return this._host;
    }

    public final void setHost(String host) {
        this._host = host;
    }

    public final int getPort() {
        return this._port;
    }

    public final void setPort(int port) {
        this._port = port;
    }

    public final String getVirtualPath() {
        if (this._connectionDetails != null) {
            return this._connectionDetails.getVirtualHost();
        }
        return this._virtualPath;
    }

    public final void setVirtualPath(String path) {
        if (this._connectionDetails != null) {
            this._connectionDetails.setVirtualHost(path);
        }
        this._virtualPath = path;
    }

    public Connection createConnection() throws JMSException {
        if (this.removeBURL == null) {
            this.removeBURL = new ThreadLocal();
            this.removeBURL.set(new Boolean(false));
        } else if (this.removeBURL.get() == null) {
            this.removeBURL.set(new Boolean(false));
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!((Boolean)AMQConnectionFactory.this.removeBURL.get()).booleanValue()) {
                    System.setProperty("qpid.dest_syntax", "BURL");
                } else {
                    System.clearProperty("qpid.dest_syntax");
                }
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty("ignore_setclientID", "true");
                return null;
            }
        });
        try {
            if (this._connectionDetails != null) {
                AMQConnection amqConnection = new AMQConnection(this._connectionDetails, this._sslConfig);
                if (logger.isDebugEnabled()) {
                    Throwable t = new Throwable();
                    logger.debug("Setting connection listener to newly created connection from stack : " + this.displayStack(t).toString());
                }
                amqConnection.setConnectionListener(this.connectionListener);
                return amqConnection;
            }
            AMQConnection amqConnection = new AMQConnection(this._host, this._port, this._defaultUsername, this._defaultPassword, null, this._virtualPath);
            amqConnection.setConnectionListener(this.connectionListener);
            return amqConnection;
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password, null);
    }

    public Connection createConnection(String userName, String password, String id) throws JMSException {
        if (this.removeBURL == null) {
            this.removeBURL = new ThreadLocal();
            this.removeBURL.set(new Boolean(false));
        } else {
            try {
                if (null == this.removeBURL.get()) {
                    this.removeBURL.set(new Boolean(false));
                }
            }
            catch (NullPointerException e) {
                this.removeBURL.set(new Boolean(false));
            }
        }
        if (!this.removeBURL.get().booleanValue()) {
            System.setProperty("qpid.dest_syntax", "BURL");
        } else {
            System.getProperties().remove("qpid.dest_syntax");
        }
        try {
            if (this._connectionDetails != null) {
                this._connectionDetails.setUsername(userName);
                this._connectionDetails.setPassword(password);
                this._connectionDetails.setClientName(id);
                AMQConnection amqConnection = new AMQConnection(this._connectionDetails, this._sslConfig);
                if (logger.isDebugEnabled()) {
                    Throwable t = new Throwable();
                    logger.debug("Setting connection listener while creating connection from stack : " + this.displayStack(t).toString());
                }
                amqConnection.setConnectionListener(this.connectionListener);
                return amqConnection;
            }
            AMQConnection amqConnection = new AMQConnection(this._host, this._port, userName, password, id, this._virtualPath);
            amqConnection.setConnectionListener(this.connectionListener);
            return amqConnection;
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (this.removeBURL == null) {
            this.removeBURL = new ThreadLocal();
            this.removeBURL.set(new Boolean(true));
        } else {
            this.removeBURL.set(new Boolean(true));
        }
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        if (this.removeBURL == null) {
            this.removeBURL = new ThreadLocal();
            this.removeBURL.set(new Boolean(true));
        } else {
            this.removeBURL.set(new Boolean(true));
        }
        return (QueueConnection)this.createConnection(username, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return (TopicConnection)this.createConnection(username, password);
    }

    public ConnectionURL getConnectionURL() {
        return this._connectionDetails;
    }

    public String getConnectionURLString() {
        return this._connectionDetails.toString();
    }

    public final void setConnectionURLString(String url) throws URLSyntaxException {
        this._connectionDetails = new AMQConnectionURL(url);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            RefAddr addr;
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(AMQConnection.class.getName()) && (addr = ref.get(AMQConnection.class.getName())) != null) {
                AMQConnection amqConnection = new AMQConnection((String)addr.getContent());
                amqConnection.setConnectionListener(this.connectionListener);
                return amqConnection;
            }
            if (ref.getClassName().equals(AMQQueue.class.getName()) && (addr = ref.get(AMQQueue.class.getName())) != null) {
                return new AMQQueue(new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQTopic.class.getName()) && (addr = ref.get(AMQTopic.class.getName())) != null) {
                return new AMQTopic(new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQConnectionFactory.class.getName()) && (addr = ref.get(AMQConnectionFactory.class.getName())) != null) {
                return new AMQConnectionFactory((String)addr.getContent());
            }
        }
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(AMQConnectionFactory.class.getName(), new StringRefAddr(AMQConnectionFactory.class.getName(), this._connectionDetails.getURL()), AMQConnectionFactory.class.getName(), null);
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    private StringWriter displayStack(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        return errors;
    }
}

