/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionClose;
import org.wso2.andes.transport.ConnectionCloseOk;
import org.wso2.andes.transport.ConnectionException;
import org.wso2.andes.transport.ConnectionHeartbeat;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.ProtocolDelegate;
import org.wso2.andes.transport.ProtocolError;
import org.wso2.andes.transport.Session;
import org.wso2.andes.transport.SessionDetach;
import org.wso2.andes.transport.SessionDetachCode;
import org.wso2.andes.transport.SessionDetached;
import org.wso2.andes.transport.util.Logger;

public abstract class ConnectionDelegate
extends MethodDelegate<Connection>
implements ProtocolDelegate<Connection> {
    private static final Logger log = Logger.get(ConnectionDelegate.class);

    @Override
    public void control(Connection conn, Method method) {
        method.dispatch(conn, this);
    }

    @Override
    public void command(Connection conn, Method method) {
        method.dispatch(conn, this);
    }

    @Override
    public void error(Connection conn, ProtocolError error) {
        conn.exception(new ConnectionException(error.getMessage()));
    }

    @Override
    public void handle(Connection conn, Method method) {
        conn.dispatch(method);
    }

    @Override
    public void connectionHeartbeat(Connection conn, ConnectionHeartbeat hearbeat) {
    }

    @Override
    public void connectionClose(Connection conn, ConnectionClose close) {
        conn.connectionCloseOk(new Option[0]);
        conn.getSender().close();
        conn.closeCode(close);
        conn.setState(Connection.State.CLOSE_RCVD);
    }

    @Override
    public void connectionCloseOk(Connection conn, ConnectionCloseOk ok) {
        conn.getSender().close();
    }

    @Override
    public void sessionDetach(Connection conn, SessionDetach dtc) {
        Session ssn = conn.getSession(dtc.getChannel());
        ssn.sessionDetached(dtc.getName(), SessionDetachCode.NORMAL, new Option[0]);
        conn.unmap(ssn);
        ssn.closed();
    }

    @Override
    public void sessionDetached(Connection conn, SessionDetached dtc) {
        Session ssn = conn.getSession(dtc.getChannel());
        if (ssn != null) {
            ssn.setDetachCode(dtc.getCode());
            conn.unmap(ssn);
            ssn.closed();
        }
    }
}

