/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.Map;
import org.wso2.andes.transport.Field;
import org.wso2.andes.transport.StructFactory;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encodable;
import org.wso2.andes.transport.codec.Encoder;

public abstract class Struct
implements Encodable {
    boolean dirty = true;

    public static Struct create(int type) {
        return StructFactory.create(type);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public abstract int getStructType();

    public abstract int getSizeWidth();

    public abstract int getPackWidth();

    public final int getEncodedType() {
        int type = this.getStructType();
        if (type < 0) {
            throw new UnsupportedOperationException();
        }
        return type;
    }

    private final boolean isBit(Field<?, ?> f) {
        return f.getType().equals(Boolean.class);
    }

    private final boolean packed() {
        return this.getPackWidth() > 0;
    }

    private final boolean encoded(Field<?, ?> f) {
        return !this.packed() || !this.isBit(f) && f.has(this);
    }

    private final int getFlagWidth() {
        return (this.getFields().size() + 7) / 8;
    }

    private final int getPaddWidth() {
        int pw = this.getPackWidth() - this.getFlagWidth();
        assert (pw > 0);
        return pw;
    }

    private final int getFlagCount() {
        return 8 * this.getPackWidth();
    }

    private final int getReservedFlagCount() {
        return this.getFlagCount() - this.getFields().size();
    }

    @Override
    public abstract void read(Decoder var1);

    @Override
    public abstract void write(Encoder var1);

    public abstract Map<String, Object> getFields();

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName());
        str.append("(");
        boolean first = true;
        for (Map.Entry<String, Object> me : this.getFields().entrySet()) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(me.getKey());
            str.append("=");
            str.append(me.getValue());
        }
        str.append(")");
        return str.toString();
    }
}

