/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.codec;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.wso2.andes.transport.Binary;
import org.wso2.andes.transport.RangeSet;
import org.wso2.andes.transport.Struct;
import org.wso2.andes.transport.Type;
import org.wso2.andes.transport.codec.Decoder;

abstract class AbstractDecoder
implements Decoder {
    private final Map<Binary, String> str8cache = new LinkedHashMap<Binary, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Binary, String> me) {
            return this.size() > 4096;
        }
    };

    AbstractDecoder() {
    }

    protected abstract byte doGet();

    protected abstract void doGet(byte[] var1);

    protected byte get() {
        return this.doGet();
    }

    protected void get(byte[] bytes) {
        this.doGet(bytes);
    }

    protected Binary get(int size) {
        byte[] bytes = new byte[size];
        this.get(bytes);
        return new Binary(bytes);
    }

    protected short uget() {
        return (short)(0xFF & this.get());
    }

    @Override
    public short readUint8() {
        return this.uget();
    }

    @Override
    public int readUint16() {
        int i = this.uget() << 8;
        return i |= this.uget();
    }

    @Override
    public long readUint32() {
        long l = this.uget() << 24;
        l |= (long)(this.uget() << 16);
        l |= (long)(this.uget() << 8);
        return l |= (long)this.uget();
    }

    @Override
    public int readSequenceNo() {
        return (int)this.readUint32();
    }

    @Override
    public long readUint64() {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l |= (long)(0xFF & this.get()) << 56 - i * 8;
        }
        return l;
    }

    @Override
    public long readDatetime() {
        return this.readUint64();
    }

    private static final String decode(byte[] bytes, int offset, int length, String charset) {
        try {
            return new String(bytes, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static final String decode(byte[] bytes, String charset) {
        return AbstractDecoder.decode(bytes, 0, bytes.length, charset);
    }

    @Override
    public String readStr8() {
        short size = this.readUint8();
        Binary bin = this.get(size);
        String str = this.str8cache.get(bin);
        if (str == null) {
            str = AbstractDecoder.decode(bin.array(), bin.offset(), bin.size(), "UTF-8");
            if (bin.hasExcessCapacity()) {
                this.str8cache.put(bin.copy(), str);
            } else {
                this.str8cache.put(bin, str);
            }
        }
        return str;
    }

    @Override
    public String readStr16() {
        int size = this.readUint16();
        byte[] bytes = new byte[size];
        this.get(bytes);
        return AbstractDecoder.decode(bytes, "UTF-8");
    }

    @Override
    public String readStr32() {
        int size = (int)this.readUint32();
        byte[] bytes = new byte[size];
        this.get(bytes);
        return AbstractDecoder.decode(bytes, "UTF-8");
    }

    @Override
    public byte[] readVbin8() {
        short size = this.readUint8();
        byte[] bytes = new byte[size];
        this.get(bytes);
        return bytes;
    }

    @Override
    public byte[] readVbin16() {
        int size = this.readUint16();
        byte[] bytes = new byte[size];
        this.get(bytes);
        return bytes;
    }

    @Override
    public byte[] readVbin32() {
        int size = (int)this.readUint32();
        byte[] bytes = new byte[size];
        this.get(bytes);
        return bytes;
    }

    @Override
    public RangeSet readSequenceSet() {
        int count = this.readUint16() / 8;
        if (count == 0) {
            return null;
        }
        RangeSet ranges = new RangeSet();
        for (int i = 0; i < count; ++i) {
            ranges.add(this.readSequenceNo(), this.readSequenceNo());
        }
        return ranges;
    }

    @Override
    public RangeSet readByteRanges() {
        throw new Error("not implemented");
    }

    @Override
    public UUID readUuid() {
        long msb = this.readUint64();
        long lsb = this.readUint64();
        return new UUID(msb, lsb);
    }

    public String readContent() {
        throw new Error("Deprecated");
    }

    @Override
    public Struct readStruct(int type) {
        long size;
        Struct st = Struct.create(type);
        int width = st.getSizeWidth();
        if (width > 0 && (size = this.readSize(width)) == 0L) {
            return null;
        }
        if (type > 0) {
            int code = this.readUint16();
            assert (code == type);
        }
        st.read(this);
        return st;
    }

    @Override
    public Struct readStruct32() {
        long size = this.readUint32();
        if (size == 0L) {
            return null;
        }
        int type = this.readUint16();
        Struct result = Struct.create(type);
        result.read(this);
        return result;
    }

    @Override
    public Map<String, Object> readMap() {
        long size = this.readUint32();
        if (size == 0L) {
            return null;
        }
        long count = this.readUint32();
        if (count == 0L) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int i = 0;
        while ((long)i < count) {
            String key = this.readStr8();
            byte code = this.get();
            Type t = this.getType(code);
            Object value = this.read(t);
            result.put(key, value);
            ++i;
        }
        return result;
    }

    @Override
    public List<Object> readList() {
        long size = this.readUint32();
        if (size == 0L) {
            return null;
        }
        long count = this.readUint32();
        if (count == 0L) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while ((long)i < count) {
            byte code = this.get();
            Type t = this.getType(code);
            Object value = this.read(t);
            result.add(value);
            ++i;
        }
        return result;
    }

    @Override
    public List<Object> readArray() {
        long size = this.readUint32();
        if (size == 0L) {
            return null;
        }
        byte code = this.get();
        Type t = this.getType(code);
        long count = this.readUint32();
        if (count == 0L) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while ((long)i < count) {
            Object value = this.read(t);
            result.add(value);
            ++i;
        }
        return result;
    }

    private Type getType(byte code) {
        Type type = Type.get(code);
        if (type == null) {
            throw new IllegalArgumentException("unknown code: " + code);
        }
        return type;
    }

    private long readSize(Type t) {
        if (t.fixed) {
            return t.width;
        }
        return this.readSize(t.width);
    }

    private long readSize(int width) {
        switch (width) {
            case 1: {
                return this.readUint8();
            }
            case 2: {
                return this.readUint16();
            }
            case 4: {
                return this.readUint32();
            }
        }
        throw new IllegalStateException("illegal width: " + width);
    }

    private byte[] readBytes(Type t) {
        long size = this.readSize(t);
        byte[] result = new byte[(int)size];
        this.get(result);
        return result;
    }

    private Object read(Type t) {
        switch (t) {
            case BIN8: 
            case UINT8: {
                return this.readUint8();
            }
            case INT8: {
                return this.get();
            }
            case CHAR: {
                return Character.valueOf((char)this.get());
            }
            case BOOLEAN: {
                return this.get() > 0;
            }
            case BIN16: 
            case UINT16: {
                return this.readUint16();
            }
            case INT16: {
                return (short)this.readUint16();
            }
            case BIN32: 
            case UINT32: {
                return this.readUint32();
            }
            case CHAR_UTF32: 
            case INT32: {
                return (int)this.readUint32();
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat((int)this.readUint32()));
            }
            case BIN64: 
            case UINT64: 
            case INT64: 
            case DATETIME: {
                return this.readUint64();
            }
            case DOUBLE: {
                return Double.longBitsToDouble(this.readUint64());
            }
            case UUID: {
                return this.readUuid();
            }
            case STR8: {
                return this.readStr8();
            }
            case STR16: {
                return this.readStr16();
            }
            case STR32: {
                return this.readStr32();
            }
            case STR8_LATIN: 
            case STR8_UTF16: 
            case STR16_LATIN: 
            case STR16_UTF16: {
                return new String(this.readBytes(t));
            }
            case MAP: {
                return this.readMap();
            }
            case LIST: {
                return this.readList();
            }
            case ARRAY: {
                return this.readArray();
            }
            case STRUCT32: {
                return this.readStruct32();
            }
            case BIN40: 
            case DEC32: 
            case BIN72: 
            case DEC64: {
                return this.readBytes(t);
            }
            case VOID: {
                return null;
            }
        }
        return this.readBytes(t);
    }
}

