/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.util.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.util.concurrent.BatchSynchQueue;
import org.wso2.andes.util.concurrent.BooleanLatch;
import org.wso2.andes.util.concurrent.Capacity;
import org.wso2.andes.util.concurrent.SynchException;
import org.wso2.andes.util.concurrent.SynchRecord;
import org.wso2.andes.util.concurrent.SynchRef;

public abstract class BatchSynchQueueBase<E>
extends AbstractQueue<E>
implements BatchSynchQueue<E> {
    private static final Logger log = LoggerFactory.getLogger(BatchSynchQueueBase.class);
    Queue<SynchRecordImpl<E>> buffer = this.createQueue();
    private int count;
    private ReentrantLock lock;
    private Condition notEmpty;
    private Condition notFull;

    public BatchSynchQueueBase() {
        this(false);
    }

    public BatchSynchQueueBase(boolean fair) {
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    @Override
    public Iterator<E> iterator() {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.insert(e, false);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        long nanos = unit.toNanos(timeout);
        try {
            do {
                if (this.insert(e, false)) {
                    boolean bl = true;
                    return bl;
                }
                try {
                    nanos = this.notFull.awaitNanos(nanos);
                }
                catch (InterruptedException ie) {
                    this.notFull.signal();
                    throw ie;
                }
            } while (nanos > 0L);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E x;
            if (this.count == 0) {
                E e = null;
                return e;
            }
            E e = x = this.extract(true, true).getElement();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            do {
                if (this.count != 0) {
                    E x;
                    E e = x = this.extract(true, true).getElement();
                    return e;
                }
                try {
                    nanos = this.notEmpty.awaitNanos(nanos);
                }
                catch (InterruptedException ie) {
                    this.notEmpty.signal();
                    throw ie;
                }
            } while (nanos > 0L);
            E e = null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.peekAtBufferHead();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.getBufferCapacity() - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        try {
            this.tryPut(e);
        }
        catch (SynchException synchException) {
            // empty catch block
        }
    }

    @Override
    public void tryPut(E e) throws InterruptedException, SynchException {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == this.getBufferCapacity()) {
                this.notFull.await();
            }
        }
        catch (InterruptedException ie) {
            this.notFull.signal();
            throw ie;
        }
        this.insert(e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            E x;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            E e = x = this.extract(true, true).getElement();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> objects) {
        return this.drainTo(objects, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> objects, int maxElements) {
        if (objects == null) {
            throw new NullPointerException();
        }
        if (objects == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int max;
            int n2 = max = maxElements >= this.count || maxElements < 0 ? this.count : maxElements;
            for (n = 0; n < max; ++n) {
                objects.add(this.extract(true, false).getElement());
            }
            if (n > 0) {
                this.notFull.signalAll();
            }
            int n3 = n;
            return n3;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SynchRef drainTo(Collection<SynchRecord<E>> c, boolean unblock) {
        return this.drainTo(c, -1, unblock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchRef drainTo(Collection<SynchRecord<E>> coll, int maxElements, boolean unblock) {
        if (coll == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int max;
            int n2 = max = maxElements >= this.count || maxElements < 0 ? this.count : maxElements;
            for (n = 0; n < max; ++n) {
                coll.add(this.extract(false, unblock));
            }
            if (n > 0) {
                this.notFull.signalAll();
            }
            SynchRefImpl synchRefImpl = new SynchRefImpl(n, coll);
            return synchRefImpl;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract <T> Queue<T> createQueue();

    protected boolean insert(E x, boolean unlockAndBlock) {
        SynchRecordImpl<E> record = new SynchRecordImpl<E>(x);
        boolean result = this.buffer.offer(record);
        if (result) {
            ++this.count;
            this.notEmpty.signal();
            if (unlockAndBlock) {
                this.lock.unlock();
                record.waitForConsumer();
            }
            return true;
        }
        return false;
    }

    protected SynchRecordImpl<E> extract(boolean unblock, boolean signal) {
        SynchRecordImpl<E> result = this.buffer.remove();
        --this.count;
        if (signal) {
            this.notFull.signal();
        }
        if (unblock) {
            result.releaseImmediately();
        }
        return result;
    }

    protected int getBufferCapacity() {
        if (this.buffer instanceof Capacity) {
            return ((Capacity)((Object)this.buffer)).getCapacity();
        }
        return Integer.MAX_VALUE;
    }

    protected E peekAtBufferHead() {
        return this.buffer.peek().getElement();
    }

    public class SynchRecordImpl<E>
    implements SynchRecord<E> {
        BooleanLatch latch = new BooleanLatch();
        E element;

        public SynchRecordImpl(E e) {
            this.element = e;
        }

        public void waitForConsumer() {
            this.latch.await();
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public void releaseImmediately() {
            this.latch.signal();
        }

        @Override
        public void reQueue() {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public void inError(Exception e) {
            throw new RuntimeException("Not implemented.");
        }
    }

    public class SynchRefImpl
    implements SynchRef {
        int numRecords;
        Collection<SynchRecord<E>> records;

        public SynchRefImpl(int n, Collection<SynchRecord<E>> records) {
            this.numRecords = n;
            this.records = records;
        }

        @Override
        public int getNumRecords() {
            return this.numRecords;
        }

        @Override
        public void unblockProducers() {
            log.debug("public void unblockProducers(): called");
            if (this.records != null) {
                for (SynchRecord record : this.records) {
                    record.releaseImmediately();
                }
            }
            this.records = null;
        }
    }
}

