/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.filter.codec.serialization;

import org.wso2.org.apache.mina.common.ByteBuffer;
import org.wso2.org.apache.mina.common.IoSession;
import org.wso2.org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.wso2.org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class ObjectSerializationDecoder
extends CumulativeProtocolDecoder {
    private final ClassLoader classLoader;
    private int maxObjectSize = 0x100000;

    public ObjectSerializationDecoder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ObjectSerializationDecoder(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
        this.classLoader = classLoader;
    }

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (!in.prefixedDataAvailable(4, this.maxObjectSize)) {
            return false;
        }
        out.write(in.getObject(this.classLoader));
        return true;
    }
}

