/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import org.wso2.org.apache.mina.common.ConnectFuture;
import org.wso2.org.apache.mina.common.ExceptionMonitor;
import org.wso2.org.apache.mina.common.IoFilterChain;
import org.wso2.org.apache.mina.common.IoHandler;
import org.wso2.org.apache.mina.common.IoServiceConfig;
import org.wso2.org.apache.mina.common.IoSessionConfig;
import org.wso2.org.apache.mina.common.support.AbstractIoFilterChain;
import org.wso2.org.apache.mina.common.support.BaseIoConnector;
import org.wso2.org.apache.mina.common.support.BaseIoConnectorConfig;
import org.wso2.org.apache.mina.common.support.BaseIoSessionConfig;
import org.wso2.org.apache.mina.common.support.DefaultConnectFuture;
import org.wso2.org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.wso2.org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.wso2.org.apache.mina.transport.vmpipe.support.VmPipe;
import org.wso2.org.apache.mina.transport.vmpipe.support.VmPipeFilterChain;
import org.wso2.org.apache.mina.transport.vmpipe.support.VmPipeIdleStatusChecker;
import org.wso2.org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.wso2.org.apache.mina.util.AnonymousSocketAddress;

public class VmPipeConnector
extends BaseIoConnector {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoConnectorConfig(){

        @Override
        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    @Override
    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    @Override
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        VmPipe entry;
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        if ((entry = VmPipeAcceptor.boundHandlers.get(address)) == null) {
            return DefaultConnectFuture.newFailedFuture(new IOException("Endpoint unavailable: " + address));
        }
        DefaultConnectFuture future = new DefaultConnectFuture();
        VmPipeSessionImpl localSession = new VmPipeSessionImpl(this, config, this.getListeners(), new AnonymousSocketAddress(), handler, entry);
        try {
            IoFilterChain filterChain = localSession.getFilterChain();
            this.getFilterChainBuilder().buildFilterChain(filterChain);
            config.getFilterChainBuilder().buildFilterChain(filterChain);
            config.getThreadModel().buildFilterChain(filterChain);
            localSession.setAttribute(AbstractIoFilterChain.CONNECT_FUTURE, future);
            this.getListeners().fireSessionCreated(localSession);
            VmPipeIdleStatusChecker.getInstance().addSession(localSession);
        }
        catch (Throwable t) {
            future.setException(t);
            return future;
        }
        VmPipeSessionImpl remoteSession = localSession.getRemoteSession();
        try {
            IoFilterChain filterChain = remoteSession.getFilterChain();
            entry.getAcceptor().getFilterChainBuilder().buildFilterChain(filterChain);
            entry.getConfig().getFilterChainBuilder().buildFilterChain(filterChain);
            entry.getConfig().getThreadModel().buildFilterChain(filterChain);
            entry.getListeners().fireSessionCreated(remoteSession);
            VmPipeIdleStatusChecker.getInstance().addSession(remoteSession);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
            remoteSession.close();
        }
        ((VmPipeFilterChain)localSession.getFilterChain()).start();
        ((VmPipeFilterChain)remoteSession.getFilterChain()).start();
        return future;
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

