/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import javax.jms.JMSException;
import javax.jms.XASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQConnectionDelegate_8_0;
import org.wso2.andes.client.JMSAMQException;
import org.wso2.andes.client.XASession_9_1;
import org.wso2.andes.client.failover.FailoverException;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.jms.ChannelLimitReachedException;

public class AMQConnectionDelegate_9_1
extends AMQConnectionDelegate_8_0 {
    private static final Logger _logger = LoggerFactory.getLogger(AMQConnectionDelegate_9_1.class);
    private AMQConnection conn;

    public AMQConnectionDelegate_9_1(AMQConnection conn) {
        super(conn);
        this.conn = conn;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.v0_91;
    }

    @Override
    public XASession createXASession(int prefetchHigh, int prefetchLow) throws JMSException {
        XASession_9_1 session;
        this.conn.checkNotClosed();
        if (this.conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this.conn.getMaximumChannelCount());
        }
        int channelId = this.conn.getNextChannelID();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Write channel open frame for channel id " + channelId);
        }
        try {
            session = new XASession_9_1(this.conn, channelId, prefetchHigh, prefetchLow);
        }
        catch (AMQException | FailoverException e) {
            JMSException jmse = new JMSException("Error creating session: " + e);
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        if (this.conn._started) {
            try {
                session.start();
            }
            catch (AMQException e) {
                throw new JMSAMQException("Failed start the XASession", e);
            }
        }
        return session;
    }
}

