/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import java.util.Arrays;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MessageCheckpointBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class MessageCheckpointBodyImpl
extends AMQMethodBody_0_9
implements MessageCheckpointBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new MessageCheckpointBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 90;
    private final byte[] _reference;
    private final AMQShortString _identifier;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageCheckpointBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._reference = this.readBytes(buffer);
        this._identifier = this.readAMQShortString(buffer);
    }

    public MessageCheckpointBodyImpl(byte[] reference, AMQShortString identifier) {
        this._reference = reference;
        this._identifier = identifier;
    }

    @Override
    public int getClazz() {
        return 120;
    }

    @Override
    public int getMethod() {
        return 90;
    }

    @Override
    public final byte[] getReference() {
        return this._reference;
    }

    @Override
    public final AMQShortString getIdentifier() {
        return this._identifier;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._reference);
        return size += this.getSizeOf(this._identifier);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeBytes(buffer, this._reference);
        this.writeAMQShortString(buffer, this._identifier);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageCheckpoint(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageCheckpointBodyImpl: ");
        buf.append("reference=");
        buf.append(this.getReference() == null ? "null" : Arrays.toString(this.getReference()));
        buf.append(", ");
        buf.append("identifier=");
        buf.append(this.getIdentifier());
        buf.append("]");
        return buf.toString();
    }
}

