/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.ui.integration.test.webapp;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.ui.page.LoginPage;
import org.wso2.appserver.integration.common.ui.page.main.WebAppListPage;
import org.wso2.appserver.integration.common.utils.ASIntegrationUITest;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;

public class ExampleTestCase
extends ASIntegrationUITest {
    private WebDriver driver;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws Exception {
        super.init();
        this.driver = BrowserManager.getWebDriver();
        this.driver.get(this.getLoginURL());
        LoginPage test = new LoginPage(this.driver);
        test.loginAs(this.userInfo.getUserName(), this.userInfo.getPassword());
        WebAppListPage webAppListPage = new WebAppListPage(this.driver);
        AssertJUnit.assertTrue((String)"Web app context not found", (boolean)webAppListPage.findWebApp("/example"));
        this.driver.findElement(By.linkText((String)"/example")).click();
    }

    @Test(groups={"wso2.as"}, description="Verify example:servlet HelloWorldExample")
    public void testHelloWorldExample() throws Exception {
        this.driver.get(this.webAppURL + "/example/servlets/");
        Assert.assertEquals((String)this.driver.getTitle(), (String)"Servlet Examples");
        this.driver.findElement(By.xpath((String)"/html/body/p[5]/table/tbody/tr/td[2]/a[2]")).click();
        Assert.assertEquals((String)this.driver.getCurrentUrl(), (String)(this.webAppURL + "/example/servlets/servlet/HelloWorldExample"));
        AssertJUnit.assertTrue((boolean)this.driver.getPageSource().contains("Hello World!"));
    }

    @Test(groups={"wso2.as"}, description="Verify example:servlet RequestInfoExample")
    public void testRequestInfoExample() throws Exception {
        this.driver.get(this.asServer.getContextUrls().getWebAppURL() + "/example/servlets/");
        Assert.assertEquals((String)this.driver.getTitle(), (String)"Servlet Examples");
        this.driver.findElement(By.xpath((String)"/html/body/p[5]/table/tbody/tr[2]/td[2]/a[2]")).click();
        Assert.assertEquals((String)this.driver.getCurrentUrl(), (String)(this.asServer.getContextUrls().getWebAppURL() + "/example/servlets/servlet/RequestInfoExample"));
        AssertJUnit.assertTrue((boolean)this.driver.getPageSource().contains("Request Information Example"));
        AssertJUnit.assertTrue((boolean)this.driver.getPageSource().contains("/example/servlets/servlet/RequestInfoExample"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.driver.quit();
    }
}

