/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.ui.integration.test.webapp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.ui.page.LoginPage;
import org.wso2.appserver.integration.common.ui.page.main.WebAppListPage;
import org.wso2.appserver.integration.common.utils.ASIntegrationUITest;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;

public class JSPSamplesTestCase
extends ASIntegrationUITest {
    private WebDriver driver;
    private static final Log log = LogFactory.getLog(JSPSamplesTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setUp() throws Exception {
        super.init();
        this.driver = BrowserManager.getWebDriver();
        this.driver.get(this.getLoginURL());
        LoginPage test = new LoginPage(this.driver);
        test.loginAs(this.userInfo.getUserName(), this.userInfo.getPassword());
        new WebAppListPage(this.driver);
    }

    @Test(groups={"wso2.as"}, description="Verify example:Expression Language")
    public void testExpressionLanguageExample() throws Exception {
        this.driver.get(this.webAppURL + "/example/jsp/");
        Assert.assertEquals((String)this.driver.getTitle(), (String)"JSP Examples");
        this.driver.findElement(By.xpath((String)"/html/body/p[4]/table/tbody/tr[2]/td[2]/a[2]")).click();
        Assert.assertEquals((String)this.driver.getCurrentUrl(), (String)(this.webAppURL + "/example/jsp/jsp2/el/basic-arithmetic.jsp"));
        WebElement table_element = this.driver.findElement(By.xpath((String)"/html/body/blockquote/code/table"));
        HashMap<String, List<String>> inputTextMap = new HashMap<String, List<String>>();
        ArrayList<String> arrList1 = new ArrayList<String>();
        arrList1.add("12001.4");
        inputTextMap.put("${1.2E4 + 1.4}", arrList1);
        ArrayList<String> arrList2 = new ArrayList<String>();
        arrList2.add("Infinity");
        inputTextMap.put("${3/0}", arrList2);
        AssertJUnit.assertTrue((boolean)this.checkThroughTable(table_element, inputTextMap));
    }

    @Test(groups={"wso2.as"}, description="Verify example: Expression Language - Composite Expressions")
    public void testCompositeExpressionExample() throws Exception {
        this.driver.get(this.webAppURL + "/example/jsp/");
        Assert.assertEquals((String)this.driver.getTitle(), (String)"JSP Examples");
        this.driver.findElement(By.xpath((String)"/html/body/p[4]/table/tbody/tr[6]/td[2]/a[2]")).click();
        Assert.assertEquals((String)this.driver.getCurrentUrl(), (String)(this.webAppURL + "/example/jsp/jsp2/el/composite.jsp"));
        WebElement table_element = this.driver.findElement(By.xpath((String)"/html/body/blockquote/code/table"));
        HashMap<String, List<String>> inputTextMap = new HashMap<String, List<String>>();
        ArrayList<String> arrList1 = new ArrayList<String>();
        arrList1.add("String");
        arrList1.add("hello world");
        inputTextMap.put("${'hello'} wo${'rld'}", arrList1);
        ArrayList<String> arrList2 = new ArrayList<String>();
        arrList2.add("String");
        arrList2.add("hello world");
        inputTextMap.put("${undefinedFoo}hello world${undefinedBar}", arrList2);
        AssertJUnit.assertTrue((boolean)this.checkThroughTable(table_element, inputTextMap));
    }

    @Test(groups={"wso2.as"}, description="Verify example: SimpleTag Handlers and JSP Fragments - Book example")
    public void simpleTagHandlerExample() throws Exception {
        this.driver.get(this.webAppURL + "/example/jsp/");
        Assert.assertEquals((String)this.driver.getTitle(), (String)"JSP Examples");
        this.driver.findElement(By.xpath((String)"/html/body/p[4]/table/tbody/tr[10]/td[2]/a[2]")).click();
        Assert.assertEquals((String)this.driver.getCurrentUrl(), (String)(this.webAppURL + "/example/jsp/jsp2/simpletag/book.jsp"));
        WebElement table_element = this.driver.findElement(By.xpath((String)"/html/body/table"));
        HashMap<String, List<String>> inputTextMap = new HashMap<String, List<String>>();
        ArrayList<String> arrList1 = new ArrayList<String>();
        arrList1.add("J. R. R. Tolkein");
        arrList1.add("J. R. R. TOLKEIN");
        inputTextMap.put("Author", arrList1);
        ArrayList<String> arrList2 = new ArrayList<String>();
        arrList2.add("0618002251");
        arrList2.add("0618002251");
        inputTextMap.put("ISBN", arrList2);
        AssertJUnit.assertTrue((boolean)this.checkThroughTable(table_element, inputTextMap));
    }

    @Test(groups={"wso2.as"}, description="Verify example: Tag Files - Display Products Example")
    public void tagFilesExample() throws Exception {
        this.driver.get(this.webAppURL + "/example/jsp/");
        Assert.assertEquals((String)this.driver.getTitle(), (String)"JSP Examples");
        this.driver.findElement(By.xpath((String)"/html/body/p[4]/table/tbody/tr[14]/td[2]/a[2]")).click();
        Assert.assertEquals((String)this.driver.getCurrentUrl(), (String)(this.webAppURL + "/example/jsp/jsp2/tagfiles/products.jsp"));
        AssertJUnit.assertTrue((boolean)this.driver.getPageSource().contains("Item: Hand-held Color PDA"));
    }

    @Test(groups={"wso2.as"}, description="Verify example: New JSP XML Syntax (.jspx) - XHTML Basic Example")
    public void xhtmlBasicExample() throws Exception {
        this.driver.get(this.webAppURL + "/example/jsp/");
        Assert.assertEquals((String)this.driver.getTitle(), (String)"JSP Examples");
        this.driver.findElement(By.xpath((String)"/html/body/p[4]/table/tbody/tr[16]/td[2]/a[2]")).click();
        Assert.assertEquals((String)this.driver.getCurrentUrl(), (String)(this.webAppURL + "/example/jsp/jsp2/jspx/basic.jspx"));
        Date dNow = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("MMMM d, yyyy, H:mm");
        log.info((Object)("DATE TEST : " + ft.format(dNow)));
        AssertJUnit.assertTrue((boolean)this.driver.getPageSource().contains(ft.format(dNow)));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.driver.quit();
    }

    private boolean checkThroughTable(WebElement table_element, Map<String, List<String>> inputTextMap) {
        List tr_collection = table_element.findElements(By.tagName((String)"tr"));
        log.info((Object)("NUMBER OF ROWS IN THIS TABLE = " + tr_collection.size()));
        int matches = 0;
        int row_num = 1;
        log.info((Object)("TEST = " + inputTextMap));
        for (WebElement trElement : tr_collection) {
            List td_collection = trElement.findElements(By.xpath((String)"td"));
            int col_num = 1;
            List<String> tdStringList = inputTextMap.get(((WebElement)td_collection.get(0)).getText());
            if (tdStringList != null) {
                int tdNum = 0;
                for (WebElement tdElement : td_collection.subList(1, td_collection.size())) {
                    log.info((Object)("row # " + row_num + ", col # " + col_num + " text=" + tdElement.getText()));
                    if (!tdElement.getText().equals(tdStringList.get(tdNum))) {
                        log.info((Object)("Missmatch : row # " + row_num + ", col # " + col_num));
                        return false;
                    }
                    log.info((Object)("Match : row # " + row_num + ", col # " + col_num));
                    ++tdNum;
                    ++col_num;
                }
                ++matches;
            }
            ++row_num;
        }
        return matches >= inputTextMap.size();
    }
}

