/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.ui.integration.test.webapp.spring;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.ui.page.LoginPage;
import org.wso2.appserver.integration.common.ui.page.main.WebAppListPage;
import org.wso2.appserver.integration.common.ui.page.main.WebAppUploadingPage;
import org.wso2.appserver.integration.common.utils.ASIntegrationUITest;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;

public class SpringWebApplicationDeploymentTestCase
extends ASIntegrationUITest {
    private WebDriver driver;
    private final String context = "/booking-faces";

    @BeforeClass(alwaysRun=true, enabled=false)
    public void setUp() throws Exception {
        super.init();
        this.driver = BrowserManager.getWebDriver();
        this.driver.get(this.getLoginURL());
        LoginPage test = new LoginPage(this.driver);
        test.loginAs(this.userInfo.getUserName(), this.userInfo.getPassword());
    }

    @Test(groups={"wso2.as"}, description="Uploading the web app which use spring", enabled=false)
    public void uploadSpringWebApplicationTest() throws Exception {
        String filePath = TestConfigurationProvider.getResourceLocation((String)"AS") + File.separator + "war" + File.separator + "spring" + File.separator + "booking-faces.war";
        WebAppUploadingPage uploadPage = new WebAppUploadingPage(this.driver);
        Assert.assertTrue((boolean)uploadPage.uploadWebApp(filePath), (String)"Web Application uploading failed");
    }

    @Test(groups={"wso2.as"}, description="Verifying Deployment the web app which use spring", dependsOnMethods={"uploadSpringWebApplicationTest"}, enabled=false)
    public void webApplicationDeploymentTest() throws Exception {
        WebAppListPage webAppListPage = new WebAppListPage(this.driver);
        AssertJUnit.assertTrue((String)"Web Application Deployment Failed. Web Application /booking-faces not found in Web application List", (boolean)this.isWebAppDeployed(webAppListPage, "/booking-faces"));
        this.driver.findElement(By.id((String)"webappsTable")).findElement(By.linkText((String)"/booking-faces")).click();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.as"}, description="Access the spring application", dependsOnMethods={"webApplicationDeploymentTest"}, enabled=false)
    public void invokeSpringApplicationTest() throws Exception {
        WebDriver driverForApp = null;
        try {
            driverForApp = BrowserManager.getWebDriver();
            driverForApp.get(this.webAppURL + "/booking-faces/spring/intro");
            driverForApp.findElement(By.linkText((String)"Start your Spring Travel experience")).click();
            driverForApp.findElement(By.xpath((String)"//*[@id=\"j_idt13:searchString\"]")).sendKeys(new CharSequence[]{"Con"});
            driverForApp.findElement(By.xpath((String)"//*[@id=\"j_idt13:findHotels\"]")).click();
            driverForApp.findElement(By.xpath((String)"//*[@id=\"j_idt12:hotels:0:viewHotelLink\"]")).click();
            driverForApp.findElement(By.xpath((String)"//*[@id=\"hotel:book\"]")).click();
            driverForApp.findElement(By.xpath((String)"/html/body/div/div[3]/div[2]/div[2]/form/fieldset/p[1]/input")).sendKeys(new CharSequence[]{"keith"});
            driverForApp.findElement(By.xpath((String)"/html/body/div/div[3]/div[2]/div[2]/form/fieldset/p[2]/input")).sendKeys(new CharSequence[]{"melbourne"});
            driverForApp.findElement(By.xpath((String)"/html/body/div/div[3]/div[2]/div[2]/form/fieldset/p[4]/input")).click();
            driverForApp.findElement(By.xpath((String)"//*[@id=\"hotel:book\"]")).click();
            driverForApp.findElement(By.xpath((String)"//*[@id=\"bookingForm:creditCard\"]")).sendKeys(new CharSequence[]{"1234567890123456"});
            driverForApp.findElement(By.xpath((String)"//*[@id=\"bookingForm:creditCardName\"]")).sendKeys(new CharSequence[]{"xyz"});
            driverForApp.findElement(By.xpath((String)"//*[@id=\"bookingForm:proceed\"]")).click();
            driverForApp.findElement(By.xpath((String)"//*[@id=\"j_idt13:confirm\"]")).click();
            Assert.assertEquals((String)driverForApp.findElement(By.xpath((String)"//*[@id=\"bookings_header\"]")).getText(), (String)"Your Hotel Bookings", (String)"Booked Hotel table Not Found");
            Assert.assertEquals((String)driverForApp.findElement(By.xpath((String)"//*[@id=\"j_idt23:j_idt24_data\"]/tr/td[1]")).getText(), (String)"Conrad Miami\n1395 Brickell Ave\nMiami, FL", (String)"Hotel Name mismatch");
        }
        finally {
            if (driverForApp != null) {
                driverForApp.quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true, enabled=false)
    public void deleteWebApplication() throws Exception {
        try {
            WebAppListPage webAppListPage = new WebAppListPage(this.driver);
            if (webAppListPage.findWebApp("/booking-faces")) {
                Assert.assertTrue((boolean)webAppListPage.deleteWebApp("/booking-faces"), (String)"Web Application Deletion failed");
                Assert.assertTrue((boolean)this.isWebAppUnDeployed(webAppListPage, "/booking-faces"));
            }
        }
        finally {
            this.driver.quit();
        }
    }

    private boolean isWebAppDeployed(WebAppListPage listPage, String webAppContext) throws IOException {
        long time;
        boolean isServiceDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < 120000L) {
            listPage = new WebAppListPage(this.driver);
            if (listPage.findWebApp(webAppContext)) {
                isServiceDeployed = true;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {}
        }
        return isServiceDeployed;
    }

    private boolean isWebAppUnDeployed(WebAppListPage listPage, String webAppContext) throws IOException {
        long time;
        boolean isServiceUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < 120000L) {
            listPage = new WebAppListPage(this.driver);
            if (!listPage.findWebApp(webAppContext)) {
                isServiceUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {}
        }
        return isServiceUnDeployed;
    }
}

