/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple;

import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.dao.jpa.BPELDAOConnectionFactoryImpl;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.DatabaseException;
import org.apache.ode.scheduler.simple.Job;
import org.apache.ode.utils.DbIsolation;
import org.apache.ode.utils.StreamUtils;

public class JdbcDelegate
implements DatabaseDelegate {
    private static final Log __log = LogFactory.getLog(JdbcDelegate.class);
    private static final String DELETE_JOB = "delete from ODE_JOB where jobid = ? and nodeid = ?";
    private static final String UPDATE_REASSIGN = "update ODE_JOB set nodeid = ?, scheduled = 0 where nodeid = ?";
    private static final String UPDATE_JOB = "update ODE_JOB set ts = ?, retryCount = ? where jobid = ?";
    private static final String UPGRADE_JOB_DEFAULT = "update ODE_JOB set nodeid = ? where nodeid is null and mod(ts,?) = ? and ts < ?";
    private static final String UPGRADE_JOB_DB2 = "update ODE_JOB set nodeid = ? where nodeid is null and mod(ts,CAST(? AS BIGINT)) = ? and ts < ?";
    private static final String UPGRADE_JOB_SQLSERVER = "update ODE_JOB set nodeid = ? where nodeid is null and (ts % ?) = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE = "update ODE_JOB set nodeid = ? where nodeid is null and convert(int, ts) % ? = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE12 = "update ODE_JOB set nodeid = ? where nodeid is null and -1 <> ? and -1 <> ? and ts < ?";
    private static final String SAVE_JOB = "insert into ODE_JOB  (jobid, nodeid, ts, scheduled, transacted, instanceId,mexId,processId,type,channel,correlatorId,correlationKeySet,retryCount,inMem,detailsExt) values(?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?)";
    private static final String GET_NODEIDS = "select distinct nodeid from ODE_JOB";
    private static final String SCHEDULE_IMMEDIATE = "select jobid, ts, transacted, scheduled, instanceId,mexId,processId,type,channel,correlatorId,correlationKeySet,retryCount,inMem,detailsExt from ODE_JOB where nodeid = ? and ts < ? order by ts";
    private static final String UPDATE_SCHEDULED = "update ODE_JOB set scheduled = 1 where jobid in (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final int UPDATE_SCHEDULED_SLOTS = 10;
    private DataSource _ds;
    private Dialect _dialect;
    private static BpelDAOConnectionFactory globalDAOConnFac;
    private static boolean hibernate;

    public JdbcDelegate(DataSource ds) {
        this._ds = ds;
        this._dialect = this.guessDialect();
    }

    public static void setGlobalDAOConnFac(BpelDAOConnectionFactory globalDAOConnFac) {
        JdbcDelegate.globalDAOConnFac = globalDAOConnFac;
    }

    public static BpelDAOConnectionFactory getGlobalDAOConnFac() {
        return globalDAOConnFac;
    }

    @Override
    public boolean deleteJob(String jobid, String nodeId) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("deleteJob " + jobid + " on node " + nodeId));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(DELETE_JOB);
            ps.setString(1, jobid);
            ps.setString(2, nodeId);
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public List<String> getNodeIds() throws DatabaseException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(GET_NODEIDS, 1003, 1007);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> nodes = new ArrayList<String>();
            while (rs.next()) {
                String nodeId = rs.getString(1);
                if (nodeId == null) continue;
                nodes.add(rs.getString(1));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("getNodeIds: " + nodes));
            }
            ArrayList<String> arrayList = nodes;
            this.close(ps);
            this.close(con);
            return arrayList;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public boolean insertJob(Job job, String nodeId, boolean loaded) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("insertJob " + job.jobId + " on node " + nodeId + " loaded=" + loaded));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            int i = 1;
            con = this.getConnection();
            ps = con.prepareStatement(SAVE_JOB);
            ps.setString(i++, job.jobId);
            ps.setString(i++, nodeId);
            ps.setLong(i++, job.schedDate);
            ps.setInt(i++, this.asInteger(loaded));
            ps.setInt(i++, this.asInteger(job.transacted));
            Scheduler.JobDetails details = job.detail;
            ps.setObject(i++, (Object)details.instanceId, -5);
            ps.setObject(i++, (Object)details.mexId, 12);
            ps.setObject(i++, (Object)details.processId, 12);
            ps.setObject(i++, (Object)details.type, 12);
            ps.setObject(i++, (Object)details.channel, 12);
            ps.setObject(i++, (Object)details.correlatorId, 12);
            ps.setObject(i++, (Object)details.correlationKeySet, 12);
            ps.setObject(i++, (Object)details.retryCount, 4);
            ps.setObject(i++, (Object)details.inMem, 4);
            if (details.detailsExt == null || details.detailsExt.size() == 0) {
                ps.setObject(i++, null, 2004);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    StreamUtils.write((OutputStream)bos, (Serializable)((Serializable)((Object)details.detailsExt)));
                }
                catch (Exception ex) {
                    __log.error((Object)("Error serializing job detail: " + job.detail));
                    throw new DatabaseException(ex);
                }
                ps.setBytes(i++, bos.toByteArray());
            }
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public boolean updateJob(Job job) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateJob " + job.jobId + " retryCount=" + job.detail.getRetryCount()));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(UPDATE_JOB);
            ps.setLong(1, job.schedDate);
            ps.setInt(2, job.detail.getRetryCount());
            ps.setString(3, job.jobId);
            boolean bl = ps.executeUpdate() == 1;
            this.close(ps);
            this.close(con);
            return bl;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    private Long asLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        throw new IllegalStateException("Can't convert to long " + o.getClass());
    }

    private Integer asInteger(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new IllegalStateException("Can't convert to integer " + o.getClass());
    }

    @Override
    public List<Job> dequeueImmediate(String nodeId, long maxtime, int maxjobs) throws DatabaseException {
        ArrayList<Job> ret = new ArrayList<Job>(maxjobs);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(SCHEDULE_IMMEDIATE);
            ps.setString(1, nodeId);
            ps.setLong(2, maxtime);
            ps.setMaxRows(maxjobs);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Map detailsExt;
                Scheduler.JobDetails details = new Scheduler.JobDetails();
                details.instanceId = this.asLong(rs.getObject("instanceId"));
                details.mexId = (String)rs.getObject("mexId");
                details.processId = (String)rs.getObject("processId");
                details.type = (String)rs.getObject("type");
                details.channel = (String)rs.getObject("channel");
                details.correlatorId = (String)rs.getObject("correlatorId");
                details.correlationKeySet = (String)rs.getObject("correlationKeySet");
                details.retryCount = this.asInteger(rs.getObject("retryCount"));
                details.inMem = this.asBoolean(rs.getInt("inMem"));
                if (rs.getObject("detailsExt") != null) {
                    try {
                        ObjectInputStream is = new ObjectInputStream(rs.getBinaryStream("detailsExt"));
                        details.detailsExt = (Map)is.readObject();
                        is.close();
                    }
                    catch (Exception e) {
                        throw new DatabaseException("Error deserializing job detailsExt", e);
                    }
                }
                if ((detailsExt = details.getDetailsExt()).get("type") != null) {
                    details.type = (String)detailsExt.get("type");
                }
                if (detailsExt.get("iid") != null) {
                    details.instanceId = (Long)detailsExt.get("iid");
                }
                if (detailsExt.get("pid") != null && detailsExt.get("pid") instanceof String) {
                    details.processId = (String)detailsExt.get("pid");
                }
                if (detailsExt.get("inmem") != null) {
                    details.inMem = (Boolean)detailsExt.get("inmem");
                }
                if (detailsExt.get("ckey") != null) {
                    details.correlationKeySet = (String)detailsExt.get("ckey");
                }
                if (detailsExt.get("channel") != null) {
                    details.channel = (String)detailsExt.get("channel");
                }
                if (detailsExt.get("mexid") != null) {
                    details.mexId = (String)detailsExt.get("mexid");
                }
                if (detailsExt.get("correlatorId") != null) {
                    details.correlatorId = (String)detailsExt.get("correlatorId");
                }
                if (detailsExt.get("retryCount") != null) {
                    details.retryCount = Integer.parseInt((String)detailsExt.get("retryCount"));
                }
                Job job = new Job(rs.getLong("ts"), rs.getString("jobid"), this.asBoolean(rs.getInt("transacted")), details);
                ret.add(job);
            }
            rs.close();
            ps.close();
            this.close(ps);
            this.close(con);
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
        return ret;
    }

    @Override
    public int updateReassign(String oldnode, String newnode) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateReassign from " + oldnode + " ---> " + newnode));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(UPDATE_REASSIGN);
            ps.setString(1, newnode);
            ps.setString(2, oldnode);
            int n = ps.executeUpdate();
            this.close(ps);
            this.close(con);
            return n;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    @Override
    public int updateAssignToNode(String node, int i, int numNodes, long maxtime) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateAsssignToNode node=" + node + " " + i + "/" + numNodes + " maxtime=" + maxtime));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = this._dialect == Dialect.SQLSERVER ? con.prepareStatement(UPGRADE_JOB_SQLSERVER) : (this._dialect == Dialect.DB2 ? con.prepareStatement(UPGRADE_JOB_DB2) : (this._dialect == Dialect.SYBASE ? con.prepareStatement(UPGRADE_JOB_SYBASE) : (this._dialect == Dialect.SYBASE12 ? con.prepareStatement(UPGRADE_JOB_SYBASE12) : con.prepareStatement(UPGRADE_JOB_DEFAULT))));
            ps.setString(1, node);
            ps.setInt(2, numNodes);
            ps.setInt(3, i);
            ps.setLong(4, maxtime);
            int n = ps.executeUpdate();
            this.close(ps);
            this.close(con);
            return n;
        }
        catch (SQLException se) {
            try {
                throw new DatabaseException(se);
            }
            catch (Throwable throwable) {
                this.close(ps);
                this.close(con);
                throw throwable;
            }
        }
    }

    private Connection getConnection() throws SQLException {
        Connection conn = null;
        if (!hibernate) {
            conn = BPELDAOConnectionFactoryImpl.getExistingJDBCConnection();
            if (conn == null) {
                BpelDAOConnectionFactory fac = JdbcDelegate.getGlobalDAOConnFac();
                if (fac != null) {
                    if (fac.getConnection() != null) {
                        conn = BPELDAOConnectionFactoryImpl.getExistingJDBCConnection();
                    } else if (__log.isDebugEnabled()) {
                        __log.debug((Object)("getConnection bpel dao connection not available: " + fac));
                    }
                } else if (__log.isDebugEnabled()) {
                    __log.debug((Object)" getConnection DAOConnFac is null ");
                }
            } else if (__log.isDebugEnabled()) {
                __log.debug((Object)("getting existing connection : " + conn));
            }
            if (conn == null) {
                conn = this._ds.getConnection();
            }
            DbIsolation.setIsolationLevel((Connection)conn);
        } else {
            conn = this._ds.getConnection();
            DbIsolation.setIsolationLevel((Connection)conn);
        }
        return conn;
    }

    private int asInteger(boolean value) {
        return value ? 1 : 0;
    }

    private boolean asBoolean(int value) {
        return value != 0;
    }

    private void close(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception e) {
                __log.warn((Object)"Exception while closing prepared statement", (Throwable)e);
            }
        }
    }

    private void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                __log.warn((Object)"Exception while closing connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialect guessDialect() {
        Dialect d = Dialect.UNKNOWN;
        Connection con = null;
        try {
            con = this.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                if (dbProductName.indexOf("DB2") >= 0) {
                    d = Dialect.DB2;
                } else if (dbProductName.indexOf("Derby") >= 0) {
                    d = Dialect.DERBY;
                } else if (dbProductName.indexOf("Firebird") >= 0) {
                    d = Dialect.FIREBIRD;
                } else if (dbProductName.indexOf("HSQL") >= 0) {
                    d = Dialect.HSQL;
                } else if (dbProductName.indexOf("H2") >= 0) {
                    d = Dialect.H2;
                } else if (dbProductName.indexOf("Microsoft SQL") >= 0) {
                    d = Dialect.SQLSERVER;
                } else if (dbProductName.indexOf("MySQL") >= 0) {
                    d = Dialect.MYSQL;
                } else if (dbProductName.indexOf("Sybase") >= 0 || dbProductName.indexOf("Adaptive") >= 0) {
                    d = Dialect.SYBASE;
                    if (dbMajorVer == 12) {
                        d = Dialect.SYBASE12;
                    }
                }
            }
        }
        catch (SQLException e) {
            __log.warn((Object)"Unable to determine database dialect", (Throwable)e);
        }
        finally {
            this.close(con);
        }
        __log.info((Object)("Using database dialect: " + (Object)((Object)d)));
        return d;
    }

    @Override
    public void acquireTransactionLocks() {
        Statement s = null;
        Connection c = null;
        try {
            c = this.getConnection();
            s = c.createStatement();
            s.execute("update ODE_JOB set jobid = '' where 1 = 0");
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("", e);
            }
        }
    }

    @Override
    public void deleteAllJobs() {
        Statement s = null;
        Connection c = null;
        try {
            c = this.getConnection();
            s = c.createStatement();
            s.execute("delete from ODE_JOB");
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("", e);
            }
        }
    }

    static {
        hibernate = false;
        String persistenceType = System.getProperty("ode.persistence");
        if (persistenceType != null && persistenceType.trim().equals("hibernate")) {
            hibernate = true;
        }
    }

    static enum Dialect {
        DB2,
        DERBY,
        FIREBIRD,
        HSQL,
        MYSQL,
        ORACLE,
        SQLSERVER,
        SYBASE,
        SYBASE12,
        H2,
        UNKNOWN;

    }
}

