/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.scheduler.simple.JobComparatorByDate;
import org.apache.ode.scheduler.simple.Task;
import org.apache.ode.scheduler.simple.TaskRunner;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

class SchedulerThread
implements Runnable {
    private static final Log __log = LogFactory.getLog(SchedulerThread.class);
    private static final int TODO_QUEUE_INITIAL_CAPACITY = 200;
    private PriorityBlockingQueue<Task> _todo;
    private ReentrantLock _lock = new ReentrantLock();
    private Condition _activity = this._lock.newCondition();
    private volatile boolean _done;
    private TaskRunner _taskrunner;
    private Thread _thread;

    SchedulerThread(TaskRunner runner) {
        this._todo = new PriorityBlockingQueue<Task>(200, new JobComparatorByDate());
        this._taskrunner = runner;
    }

    void start() {
        if (this._thread != null) {
            return;
        }
        this._done = false;
        this._thread = new Thread((Runnable)this, "OdeScheduler");
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this._thread == null) {
            return;
        }
        this._done = true;
        this._lock.lock();
        try {
            this._activity.signal();
        }
        finally {
            this._lock.unlock();
        }
        while (this._thread != null) {
            try {
                this._thread.join();
                this._thread = null;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Task task) {
        this._lock.lock();
        try {
            this._todo.add(task);
            this._activity.signal();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue(Task task) {
        this._lock.lock();
        try {
            this._todo.remove(task);
            this._activity.signal();
        }
        finally {
            this._lock.unlock();
        }
    }

    public int size() {
        return this._todo.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._done) {
            this._lock.lock();
            try {
                long nextjob;
                while ((nextjob = this.nextJobTime()) > 0L && !this._done) {
                    this._activity.await(nextjob, TimeUnit.MILLISECONDS);
                }
                if (this._done || nextjob != 0L) continue;
                Task task = this._todo.take();
                this._taskrunner.runTask(task);
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                this._lock.unlock();
            }
        }
    }

    private long nextJobTime() {
        assert (this._lock.isLocked());
        Task job = this._todo.peek();
        if (job == null) {
            return Long.MAX_VALUE;
        }
        return Math.max(0L, job.schedDate - System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTasks(final Class<? extends Task> tasktype) {
        this._lock.lock();
        try {
            CollectionsX.remove_if(this._todo, (MemberOfFunction)new MemberOfFunction<Task>(){

                public boolean isMember(Task o) {
                    return tasktype.isAssignableFrom(o.getClass());
                }
            });
        }
        finally {
            this._lock.unlock();
        }
    }
}

