/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.extension.logger;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.explang.ConfigurationException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OExpressionLanguage;
import org.apache.ode.bpel.runtime.ExprEvaluationContextImpl;
import org.apache.ode.bpel.runtime.ExtensionContextImpl;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.extension.ExtensionContext;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.bpel.extension.logger.LoggerConstants;
import org.wso2.carbon.bpel.extension.logger.LoggerExtensionOperation;

public class LogActivity {
    private ExtensionContext extensionContext;
    private Element element;
    private String logLevel;
    public static final Log log = LogFactory.getLog((String)LoggerExtensionOperation.class.getName());

    public LogActivity(ExtensionContext extensionContext, Element element) {
        this.extensionContext = extensionContext;
        this.element = element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runLogActivity() throws FaultException {
        String variableName = "";
        String part = "";
        String i_id = "";
        int fromTagCount = 0;
        this.logLevel = this.getLogLevel();
        i_id = String.valueOf(this.get_iid());
        while (this.element.getElementsByTagNameNS("http://org.wso2.carbon.bpel.logger", "from").item(fromTagCount) != null) {
            Node fromNode = this.element.getElementsByTagNameNS("http://org.wso2.carbon.bpel.logger", "from").item(fromTagCount);
            variableName = this.getVaribleName(fromNode);
            part = this.getPartName(fromNode);
            if (this.getLiteral(fromNode) != null) {
                this.log("[" + i_id + "] " + this.getLiteral(fromNode).replace("\n", "").replace("\r", ""), this.logLevel);
            }
            if (this.getXpath(fromNode) != null) {
                this.evaluateXpath(this.getXpath(fromNode));
            }
            if (variableName != null && part != null) {
                int partCount = 0;
                int variablePartIndex = 0;
                boolean hasPart = false;
                try {
                    while (this.extensionContext.readVariable(variableName).getChildNodes().item(partCount) != null) {
                        try {
                            if (part.equalsIgnoreCase(this.extensionContext.readVariable(variableName).getChildNodes().item(partCount).getLocalName())) {
                                hasPart = true;
                                variablePartIndex = partCount;
                            }
                        }
                        catch (FaultException e) {
                            e.printStackTrace();
                        }
                        ++partCount;
                    }
                }
                catch (FaultException e) {
                    e.printStackTrace();
                }
                if (!hasPart) {
                    log.error((Object)("part specified in the varialbe " + variableName + " does not exist"));
                    throw new FaultException(new QName("http://org.wso2.carbon.bpel.logger"), "part specified in the varialbe " + variableName + " does not exist");
                }
                String logtext = null;
                try {
                    logtext = DOMUtils.domToString((Node)this.extensionContext.readVariable(variableName).getChildNodes().item(variablePartIndex));
                    logtext = logtext.replace("\n", "").replace("\r", "");
                }
                catch (FaultException e) {
                    e.printStackTrace();
                }
                this.log("[" + i_id + "] " + logtext, this.logLevel);
            } else if (variableName != null) {
                String logtext = null;
                logtext = this.extensionContext.readVariable(variableName).getTextContent();
                logtext = logtext.replace("\n", "").replace("\r", "");
                this.log("[" + i_id + "] " + logtext, this.logLevel);
            }
            ++fromTagCount;
        }
        return;
    }

    private String getVaribleName(Node fromNode) {
        if (fromNode.getAttributes().getNamedItem("variable") != null) {
            return fromNode.getAttributes().getNamedItem("variable").getTextContent();
        }
        return null;
    }

    private String getPartName(Node fromNode) {
        if (fromNode.getAttributes().getNamedItem("partIndex") != null) {
            return fromNode.getAttributes().getNamedItem("partIndex").getTextContent();
        }
        return null;
    }

    private String getTextValue(ExtensionContext extensionContext, String variable, int itemIndex) {
        try {
            return extensionContext.readVariable(variable).getFirstChild().getFirstChild().getChildNodes().item(itemIndex).getTextContent();
        }
        catch (FaultException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getLiteral(Node fromNode) {
        String literal = fromNode.getTextContent();
        if (literal != null && !literal.equalsIgnoreCase("") && this.getXpath(fromNode) == null) {
            literal = DOMUtils.domToString((Node)fromNode.getChildNodes().item(1));
        }
        if (literal.contains("$") || "".equalsIgnoreCase(literal)) {
            return null;
        }
        return literal;
    }

    private String getXpath(Node fromNode) {
        if (fromNode.getAttributes().getNamedItem("xpath") != null) {
            return fromNode.getAttributes().getNamedItem("xpath").getTextContent();
        }
        return null;
    }

    private String getLogActivityName() {
        return this.element.getAttribute("name");
    }

    private String getLogLevel() {
        return this.element.getAttribute("level");
    }

    private Long get_iid() {
        return this.extensionContext.getInternalInstance().getPid();
    }

    private void log(String logText, String logLevel) {
        if ("info".equalsIgnoreCase(logLevel)) {
            log.info((Object)logText);
        } else if ("debug".equalsIgnoreCase(logLevel)) {
            log.debug((Object)logText);
        } else if ("warn".equalsIgnoreCase(logLevel)) {
            log.warn((Object)logText);
        } else if ("fatal".equalsIgnoreCase(logLevel)) {
            log.fatal((Object)logText);
        }
    }

    public void evaluateXpath(String xpath) {
        QName _qnFnGetVariableData = new QName(LoggerConstants.BPEL11_NS, "getVariableData");
        QName _qnFnGetVariableProperty = new QName(LoggerConstants.BPEL11_NS, "getVariableProperty");
        QName _qnFnGetLinkStatus = new QName(LoggerConstants.BPEL11_NS, "getLinkStatus");
        QName _qnFngetDoXslTransform = new QName(LoggerConstants.BPEL11_NS, "getDoXslTransform");
        OXPath20ExpressionBPEL20 oexp = new OXPath20ExpressionBPEL20(this.extensionContext.getInternalInstance().getProcessModel().getOwner(), _qnFnGetVariableData, _qnFnGetVariableProperty, _qnFnGetLinkStatus, _qnFngetDoXslTransform, false);
        OExpressionLanguage oExpressionLanguage = new OExpressionLanguage(this.extensionContext.getProcessModel().getOwner(), null);
        oExpressionLanguage.expressionLanguageUri = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath2.0";
        oexp.expressionLanguage = oExpressionLanguage;
        oExpressionLanguage.properties.put("runtime-class", "org.apache.ode.bpel.elang.xpath20.runtime.XPath20ExpressionRuntime");
        try {
            this.extensionContext.getInternalInstance().getExpLangRuntime().registerRuntime(oExpressionLanguage);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        oexp.insertMissingData = true;
        ScopeFrame scopeFrame = ((ExtensionContextImpl)this.extensionContext).getScopeFrame();
        ExprEvaluationContextImpl exprEvaluationContext = new ExprEvaluationContextImpl(scopeFrame, this.extensionContext.getInternalInstance());
        try {
            oexp.vars = (HashMap)this.extensionContext.getVisibleVariables();
        }
        catch (FaultException e) {
            e.printStackTrace();
        }
        oexp.namespaceCtx = this.extensionContext.getProcessModel().namespaceContext;
        try {
            oexp.xpath = xpath;
            List result = this.extensionContext.getInternalInstance().getExpLangRuntime().evaluate((OExpression)oexp, (EvaluationContext)exprEvaluationContext);
            if (result != null) {
                ListIterator itorator = result.listIterator();
                while (itorator.hasNext()) {
                    this.log("[" + String.valueOf(this.get_iid()) + "] " + xpath + " value :" + itorator.next().toString(), this.logLevel);
                }
            }
        }
        catch (FaultException e) {
            e.printStackTrace();
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
    }
}

