/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.samples.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Properties;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceStub;
import org.wso2.carbon.utils.NetworkUtils;

public class RegistryService {
    private static Properties prop = new Properties();

    public static Properties getRegistryProperties(String location) {
        Properties properties = null;
        try {
            prop.load(new FileInputStream(System.getProperty("user.dir") + File.separator + "repository" + File.separator + "conf" + File.separator + "PropertyReaderExt.properties"));
            String clientTrustStorePath = prop.getProperty("clientTrustStorePath");
            String trustStorePassword = prop.getProperty("clientTrustStorePassword");
            String trustStoreType = prop.getProperty("clientTrustStoreType");
            RegistryService.setKeyStore(clientTrustStorePath, trustStorePassword, trustStoreType);
            String resourceAdminServiceURL = "https://" + prop.getProperty("bps.mgt.hostname") + ":" + prop.getProperty("bps.mgt.port") + "/services/ResourceAdminService";
            ResourceAdminServiceStub resourceAdminServiceStub = new ResourceAdminServiceStub(resourceAdminServiceURL);
            ServiceClient client = resourceAdminServiceStub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)RegistryService.login());
            resourceAdminServiceStub._getServiceClient().getOptions().setTimeOutInMilliSeconds(600000L);
            File temp = new File("tmp" + File.separator + "temp.properties");
            FileWriter fw = new FileWriter(temp);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(resourceAdminServiceStub.getTextContent(location).toString());
            bw.close();
            properties = new Properties();
            properties.load(new FileInputStream(temp.getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static void setKeyStore(String clientTrustStorePath, String trustStorePassword, String trustStoreType) {
        System.setProperty("javax.net.ssl.trustStore", clientTrustStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        System.setProperty("javax.net.ssl.trustStoreType", trustStoreType);
    }

    public static String login() throws Exception {
        String authenticationAdminServiceURL = "https://" + prop.getProperty("bps.mgt.hostname") + ":" + prop.getProperty("bps.mgt.port") + "/services/AuthenticationAdmin";
        AuthenticationAdminStub authenticationAdminStub = new AuthenticationAdminStub(authenticationAdminServiceURL);
        ServiceClient client = authenticationAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        String userName = prop.getProperty("wso2.bps.username");
        String password = prop.getProperty("wso2.bps.password");
        String hostName = NetworkUtils.getLocalHostname();
        authenticationAdminStub.login(userName, password, hostName);
        ServiceContext serviceContext = authenticationAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
        return (String)serviceContext.getProperty("Cookie");
    }
}

