/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.bpmn;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.bps.integration.common.clients.bpmn.RestClientException;

public class ActivitiRestClient {
    private static final Log log = LogFactory.getLog(ActivitiRestClient.class);
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "admin";
    private static final String USER_CLAIM = "paul";
    private static final String USER_DELEGATE = "will";
    private static final String NOT_AVAILABLE = "Not Available";
    private static final String AVAILABLE = "Available";
    private static final String ID = "id";
    private static final String NAME = "name";
    private int port;
    private String hostname = "";
    private URL serviceURL;

    public ActivitiRestClient(String portM, String hostnameM) throws MalformedURLException {
        this.port = Integer.parseInt(portM);
        this.hostname = hostnameM;
        this.serviceURL = new URL("http", this.hostname, this.port, "/bpmn/");
    }

    public String[] deployBPMNPackage(String filePath, String fileName) throws RestClientException, IOException, JSONException {
        String url = this.serviceURL + "repository/deployments";
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addBinaryBody("file", new File(filePath), ContentType.MULTIPART_FORM_DATA, fileName);
        HttpEntity multipart = builder.build();
        httpPost.setEntity(multipart);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String status = response.getStatusLine().toString();
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        if (status.contains(Integer.toString(201)) || status.contains(Integer.toString(200))) {
            String deploymentID = jsonResponseObject.getString(ID);
            String name = jsonResponseObject.getString(NAME);
            return new String[]{status, deploymentID, name};
        }
        if (status.contains(Integer.toString(500))) {
            String errorMessage = jsonResponseObject.getString("errorMessage");
            throw new RestClientException(errorMessage);
        }
        throw new RestClientException("Failed to deploy package " + fileName);
    }

    public String[] getDeploymentInfoById(String deploymentID) throws RestClientException, IOException, JSONException {
        String url = this.serviceURL + "repository/deployments/" + deploymentID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String status = response.getStatusLine().toString();
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        if (status.contains(Integer.toString(201)) || status.contains(Integer.toString(200))) {
            String depID = jsonResponseObject.getString(ID);
            String name = jsonResponseObject.getString(NAME);
            return new String[]{status, depID, name};
        }
        if (status.contains(Integer.toString(404))) {
            throw new RestClientException(NOT_AVAILABLE);
        }
        throw new RestClientException("Cannot find deployment");
    }

    public String unDeployBPMNPackage(String deploymentID) throws IOException {
        String url = this.serviceURL + "repository/deployments/" + deploymentID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpDelete httpDelete = new HttpDelete(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        return response.getStatusLine().toString();
    }

    public String[] findProcessDefinitionInfoById(String deploymentID) throws IOException, JSONException {
        String url = this.serviceURL + "repository/process-definitions";
        String definitionId = "";
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String status = response.getStatusLine().toString();
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        JSONArray data = jsonResponseObject.getJSONArray("data");
        int responseObjectSize = Integer.parseInt(jsonResponseObject.get("total").toString());
        for (int j = 0; j < responseObjectSize; ++j) {
            if (!data.getJSONObject(j).getString("deploymentId").equals(deploymentID)) continue;
            definitionId = data.getJSONObject(j).getString(ID);
        }
        return new String[]{status, definitionId};
    }

    public String searchProcessInstanceByDefintionID(String processDefintionID) throws IOException {
        String url = this.serviceURL + "query/process-instances";
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        StringEntity params = new StringEntity("{\"processDefinitionId\":\"" + processDefintionID + "\"}", ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response.getStatusLine().toString();
    }

    public String validateProcessInstanceById(String processDefinitionID) throws IOException, JSONException, RestClientException {
        String url = this.serviceURL + "runtime/process-instances";
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        JSONArray data = jsonResponseObject.getJSONArray("data");
        int responseObjectSize = Integer.parseInt(jsonResponseObject.get("total").toString());
        for (int j = 0; j < responseObjectSize; ++j) {
            if (!data.getJSONObject(j).getString("processDefinitionId").equals(processDefinitionID)) continue;
            return AVAILABLE;
        }
        throw new RestClientException(NOT_AVAILABLE);
    }

    public String[] startProcessInstanceByDefintionID(String processDefintionID) throws IOException, JSONException, RestClientException {
        String url = this.serviceURL + "runtime/process-instances";
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        StringEntity params = new StringEntity("{\"processDefinitionId\":\"" + processDefintionID + "\"}", ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String status = response.getStatusLine().toString();
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        if (status.contains(Integer.toString(201)) || status.contains(Integer.toString(200))) {
            String processInstanceID = jsonResponseObject.getString(ID);
            return new String[]{status, processInstanceID};
        }
        throw new RestClientException("Cannot Find Process Instance");
    }

    public String activateProcessInstanceById(String processDefintionID) throws IOException {
        String url = this.serviceURL + "runtime/process-instances/" + processDefintionID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPut httpPut = new HttpPut(url);
        StringEntity params = new StringEntity("{\"action\":\"activate\"}", ContentType.APPLICATION_JSON);
        httpPut.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    public String[] suspendProcessInstanceById(String processInstanceID) throws IOException, JSONException, RestClientException {
        String url = this.serviceURL + "runtime/process-instances/" + processInstanceID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPut httpPut = new HttpPut(url);
        StringEntity params = new StringEntity("{\"action\":\"suspend\"}", ContentType.APPLICATION_JSON);
        httpPut.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        String status = response.getStatusLine().toString();
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        if (status.contains(Integer.toString(201)) || status.contains(Integer.toString(200))) {
            String state = jsonResponseObject.getString("suspended");
            return new String[]{status, state};
        }
        throw new RestClientException("Cannot Suspend Process");
    }

    public String getSuspendedStateOfProcessInstanceByID(String processInstanceID) throws IOException, JSONException {
        String url = this.serviceURL + "runtime/process-instances/" + processInstanceID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject resObj = new JSONObject(responseData);
        return resObj.getString("suspended");
    }

    public String[] getValueOfVariableOfProcessInstanceById(String processInstanceId, String variable) throws IOException, JSONException {
        String url = this.serviceURL + "runtime/process-instances/" + processInstanceId + "/variables/" + variable;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject resObj = new JSONObject(responseData);
        String status = response.getStatusLine().toString();
        String name = resObj.getString(NAME);
        String value = resObj.getString("value");
        return new String[]{status, name, value};
    }

    public String deleteProcessInstanceByID(String processInstanceId) throws IOException {
        String url = this.serviceURL + "runtime/process-instances/" + processInstanceId;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpDelete httpDelete = new HttpDelete(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        return response.getStatusLine().toString();
    }

    public String getDelegationsStateByTaskId(String taskID) throws IOException, JSONException {
        String url = this.serviceURL + "runtime/tasks/" + taskID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject resObj = new JSONObject(responseData);
        return resObj.getString("delegationState");
    }

    public String resolveTaskByTaskId(String taskID) throws IOException {
        String url = this.serviceURL + "runtime/tasks/" + taskID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        StringEntity params = new StringEntity("{\"action\" : \"resolve\"}", ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response.getStatusLine().toString();
    }

    public String getAssigneeByTaskId(String taskID) throws IOException, JSONException {
        String url = this.serviceURL + "runtime/tasks/" + taskID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject resObj = new JSONObject(responseData);
        return resObj.getString("assignee");
    }

    public String getCommentByTaskIdAndCommentId(String taskID, String commentID) throws IOException, JSONException {
        String url = this.serviceURL + "runtime/tasks/" + taskID + "/comments/" + commentID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject resObj = new JSONObject(responseData);
        return resObj.getString("message");
    }

    public String[] findTaskIdByProcessInstanceID(String processInstanceId) throws IOException, JSONException {
        String url = this.serviceURL + "runtime/tasks";
        String taskId = "";
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        String status = response.getStatusLine().toString();
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        JSONArray data = jsonResponseObject.getJSONArray("data");
        int responseObjectSize = Integer.parseInt(jsonResponseObject.get("total").toString());
        for (int j = 0; j < responseObjectSize; ++j) {
            if (!data.getJSONObject(j).getString("processInstanceId").equals(processInstanceId)) continue;
            taskId = data.getJSONObject(j).getString(ID);
        }
        return new String[]{status, taskId};
    }

    public String claimTaskByTaskId(String taskID) throws IOException {
        String url = this.serviceURL + "runtime/tasks/" + taskID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        StringEntity params = new StringEntity("{\"action\" : \"claim\",\"assignee\" :\"paul\"}", ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response.getStatusLine().toString();
    }

    public String delegateTaskByTaskId(String taskID) throws IOException {
        String url = this.serviceURL + "runtime/tasks/" + taskID;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        StringEntity params = new StringEntity("{\"action\" : \"delegate\",\"assignee\" :\"will\"}", ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response.getStatusLine().toString();
    }

    public String[] addNewCommentOnTaskByTaskId(String taskID, String comment) throws RestClientException, IOException, JSONException {
        String url = this.serviceURL + "runtime/tasks/" + taskID + "/comments";
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = new HttpPost(url);
        StringEntity params = new StringEntity("{\"message\" : \"" + comment + "\",\"saveProcessInstanceId\" : true}", ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String status = response.getStatusLine().toString();
        String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject jsonResponseObject = new JSONObject(responseData);
        if (status.contains(Integer.toString(201)) || status.contains(Integer.toString(200))) {
            String message = jsonResponseObject.getString("message");
            String commentID = jsonResponseObject.getString(ID);
            return new String[]{status, message, commentID};
        }
        throw new RestClientException("Cannot Add Comment");
    }

    public String deleteTaskByTaskId(String taskId, boolean cascadeHistory, String deleteReason) throws IOException {
        String url = this.serviceURL + "runtime/tasks/" + taskId + "?cascadeHistory=" + cascadeHistory + "&deleteReason=" + deleteReason;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpDelete httpDelete = new HttpDelete(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        return response.getStatusLine().toString();
    }

    private DefaultHttpClient getHttpClient() {
        HttpHost target = new HttpHost(this.hostname, this.port, "http");
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        return httpClient;
    }
}

