/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.bpmn;

import java.io.File;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.UploadedFileItem;
import org.wso2.carbon.bpmn.stub.BPMNUploaderServiceStub;

public class BPMNUploaderClient {
    private static final Log log = LogFactory.getLog(BPMNUploaderClient.class);
    private static final String serviceName = "BPMNUploaderService";
    private BPMNUploaderServiceStub bpmnUploaderServiceStub;

    public BPMNUploaderClient(String serviceEndPoint, String sessionCookie) throws AxisFault {
        String uploaderServiceURL = serviceEndPoint + serviceName;
        this.bpmnUploaderServiceStub = new BPMNUploaderServiceStub(uploaderServiceURL);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.bpmnUploaderServiceStub);
    }

    public boolean deployBPMN(String packageName, String dirPath) throws RemoteException, InterruptedException {
        this.deployPackage(packageName, dirPath, this.bpmnUploaderServiceStub);
        return false;
    }

    private UploadedFileItem getUploadedFileItem(DataHandler dataHandler, String fileName, String fileType) {
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        uploadedFileItem.setDataHandler(dataHandler);
        uploadedFileItem.setFileName(fileName);
        uploadedFileItem.setFileType(fileType);
        return uploadedFileItem;
    }

    private void deployPackage(String packageName, String resourceDir, BPMNUploaderServiceStub bpmnUploaderServiceStub) throws RemoteException, InterruptedException {
        String sampleArchiveName = packageName + ".bar";
        log.info((Object)(resourceDir + File.separator + sampleArchiveName));
        FileDataSource BPMNDataSource = new FileDataSource(resourceDir + File.separator + sampleArchiveName);
        UploadedFileItem[] uploadedFileItems = new UploadedFileItem[]{this.getUploadedFileItem(new DataHandler((DataSource)BPMNDataSource), sampleArchiveName, "bar")};
        log.info((Object)("Deploying " + sampleArchiveName));
        bpmnUploaderServiceStub.uploadService(uploadedFileItems);
    }
}

