/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.bpmn;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.bps.integration.common.clients.bpmn.BPMNUploaderClient;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNDeployment;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNInstance;
import org.wso2.carbon.bpmn.core.mgt.model.xsd.BPMNProcess;
import org.wso2.carbon.bpmn.stub.BPMNDeploymentServiceStub;
import org.wso2.carbon.bpmn.stub.BPMNInstanceServiceStub;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;
import sun.misc.BASE64Decoder;

public class WorkflowServiceClient {
    private static final Log log = LogFactory.getLog(BPMNUploaderClient.class);
    BPMNInstanceServiceStub instanceServiceStub = null;
    BPMNDeploymentServiceStub deploymentServiceStub = null;

    public WorkflowServiceClient(String backendServerURL, String sessionCookie) throws AxisFault {
        String deploymentServiceURL = backendServerURL + "BPMNDeploymentService";
        this.deploymentServiceStub = new BPMNDeploymentServiceStub(deploymentServiceURL);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.deploymentServiceStub);
        String instanceServiceURL = backendServerURL + "BPMNInstanceService";
        this.instanceServiceStub = new BPMNInstanceServiceStub(instanceServiceURL);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.instanceServiceStub);
    }

    public void startProcess(String processId) throws Exception {
        this.instanceServiceStub.startProcess(processId);
    }

    public BPMNDeployment[] getDeployments() throws Exception {
        return this.deploymentServiceStub.getDeployments();
    }

    public int getInstanceCount() throws Exception {
        return this.instanceServiceStub.getInstanceCount();
    }

    public BPMNProcess[] getProcesses() throws Exception {
        return this.deploymentServiceStub.getDeployedProcesses();
    }

    public BPMNProcess getProcessById(String processId) throws Exception {
        BPMNProcess bpmnProcess = null;
        for (BPMNProcess process : this.deploymentServiceStub.getDeployedProcesses()) {
            if (!process.getProcessId().equals(processId)) continue;
            bpmnProcess = process;
        }
        return bpmnProcess;
    }

    public BPMNInstance[] getProcessInstances() throws Exception {
        return this.instanceServiceStub.getProcessInstances();
    }

    public BPMNInstance getProcessInstanceById(String instanceId) throws Exception {
        for (BPMNInstance instance : this.instanceServiceStub.getProcessInstances()) {
            if (!instance.getInstanceId().equals(instanceId)) continue;
            return instance;
        }
        return null;
    }

    public void deleteProcessInstance(String instanceID) throws Exception {
        this.instanceServiceStub.deleteProcessInstance(instanceID);
    }

    public void suspendProcessInstance(String instanceID) throws Exception {
        this.instanceServiceStub.suspendProcessInstance(instanceID);
    }

    public void activateProcessInstance(String instanceID) throws Exception {
        this.instanceServiceStub.activateProcessInstance(instanceID);
    }

    public BPMNProcess[] getProcessListByDeploymentID(String deploymentID) throws Exception {
        ArrayList<BPMNProcess> processes = new ArrayList<BPMNProcess>();
        for (BPMNProcess process : this.getProcesses()) {
            if (!process.getDeploymentId().equals(deploymentID)) continue;
            processes.add(process);
        }
        return processes.toArray(new BPMNProcess[processes.size()]);
    }

    public String getProcessDiagram(String processId) throws Exception {
        String dataUri = null;
        OutputStream baos = null;
        try {
            String imageString = this.deploymentServiceStub.getProcessDiagram(processId);
            BufferedImage bufferedImage = this.decodeToImage(imageString);
            baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        }
        catch (Exception e) {
            throw new IOException("Failed to get the process diagram", e);
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    dataUri = "data:image/png;base64," + DatatypeConverter.printBase64Binary((byte[])((ByteArrayOutputStream)baos).toByteArray());
                    ((ByteArrayOutputStream)baos).close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Exception occurred when closing the stream", (Throwable)e);
            }
        }
        return dataUri;
    }

    public String getProcessModel(String processId) throws Exception {
        String tRawXML = this.deploymentServiceStub.getProcessModel(processId);
        tRawXML = tRawXML.replaceAll("\n|\\r|\\f|\\t", "");
        tRawXML = tRawXML.replaceAll("> +<", "><");
        ByteArrayInputStream xmlIn = new ByteArrayInputStream(tRawXML.getBytes());
        XMLPrettyPrinter xmlPrettyPrinter = new XMLPrettyPrinter((InputStream)xmlIn);
        tRawXML = xmlPrettyPrinter.xmlFormat().replaceAll("<", "&lt").replaceAll(">", "&gt");
        return tRawXML;
    }

    public void undeploy(String deploymentName) throws Exception {
        Thread.sleep(2000L);
        this.deploymentServiceStub.undeploy(deploymentName);
    }

    private BufferedImage decodeToImage(String imageString) throws IOException {
        BufferedImage image = null;
        try (ByteArrayInputStream bis = null;){
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(imageString);
            bis = new ByteArrayInputStream(imageByte);
            image = ImageIO.read(bis);
        }
        return image;
    }
}

