/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.humantasks;

import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.carbon.humantask.stub.mgt.HumanTaskPackageManagementStub;
import org.wso2.carbon.humantask.stub.mgt.PackageManagementException;
import org.wso2.carbon.humantask.stub.mgt.types.DeployedTaskDefinitionsPaginated;
import org.wso2.carbon.humantask.stub.mgt.types.HumanTaskPackageDownloadData;
import org.wso2.carbon.humantask.stub.mgt.types.TaskDefinition_type0;
import org.wso2.carbon.humantask.stub.mgt.types.TaskInfoType;
import org.wso2.carbon.humantask.stub.mgt.types.Task_type0;

public class HumanTaskPackageManagementClient {
    private static final Log log = LogFactory.getLog(HumanTaskPackageManagementClient.class);
    protected static final String HUMANTASK_PACKAGE_MANAGEMENT_SERVICE = "HumanTaskPackageManagement";
    private HumanTaskPackageManagementStub humanTaskPackageManagementStub = null;

    public HumanTaskPackageManagementClient(String serviceEndPoint, String sessionCookie) throws AxisFault {
        String packageMgtServiceUrl = serviceEndPoint + HUMANTASK_PACKAGE_MANAGEMENT_SERVICE;
        this.humanTaskPackageManagementStub = new HumanTaskPackageManagementStub(packageMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.humanTaskPackageManagementStub);
    }

    public HumanTaskPackageManagementClient(String serviceEndPoint, String username, String password) throws AxisFault {
        String packageMgtServiceUrl = serviceEndPoint + HUMANTASK_PACKAGE_MANAGEMENT_SERVICE;
        this.humanTaskPackageManagementStub = new HumanTaskPackageManagementStub(packageMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(username, password, (Stub)this.humanTaskPackageManagementStub);
    }

    public void unDeployHumanTask(String humantaskPackageName, String aTaskDefinitionName) throws PackageManagementException, InterruptedException, RemoteException {
        this.humanTaskPackageManagementStub.undeployHumanTaskPackage(humantaskPackageName);
        Thread.sleep(10000L);
        DeployedTaskDefinitionsPaginated deployedTaskDefinitions = this.humanTaskPackageManagementStub.listDeployedTaskDefinitionsPaginated(0);
        boolean packageUndeployed = true;
        if (deployedTaskDefinitions != null && deployedTaskDefinitions.getTaskDefinition() != null) {
            for (TaskDefinition_type0 definitionType : deployedTaskDefinitions.getTaskDefinition()) {
                if (definitionType == null || !aTaskDefinitionName.equals(definitionType.getTaskName())) continue;
                packageUndeployed = false;
                log.error((Object)"Service still exists, Undeployment failed");
                break;
            }
        }
        if (packageUndeployed) {
            log.info((Object)(humantaskPackageName + " has undeployed successfully"));
        }
    }

    public Task_type0[] listTasksInPackage(String packageName) throws Exception {
        try {
            return this.humanTaskPackageManagementStub.listTasksInPackage(packageName);
        }
        catch (Exception e) {
            String errorMsg = "Unable to get Task list in Package for " + packageName;
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
    }

    public DeployedTaskDefinitionsPaginated listDeployedTaskDefinitionsPaginated(int page) throws Exception {
        try {
            return this.humanTaskPackageManagementStub.listDeployedTaskDefinitionsPaginated(page);
        }
        catch (Exception e) {
            String errorMsg = "Unable to get list Deployed Task Definitions for page " + page;
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
    }

    public TaskInfoType getTaskInfo(QName taskId) throws Exception {
        try {
            return this.humanTaskPackageManagementStub.getTaskInfo(taskId);
        }
        catch (Exception e) {
            String errorMsg = "Unable to get task info task ID" + taskId.toString();
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
    }

    public HumanTaskPackageDownloadData downloadHumanTaskPackage(String packageName) throws Exception {
        try {
            return this.humanTaskPackageManagementStub.downloadHumanTaskPackage(packageName);
        }
        catch (Exception e) {
            String errorMsg = "Unable to get HumanTask Package DownloadData for package name " + packageName;
            log.error((Object)errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
    }
}

