/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.bpel;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.carbon.bpel.stub.mgt.InstanceManagementException;
import org.wso2.carbon.bpel.stub.mgt.InstanceManagementServiceStub;
import org.wso2.carbon.bpel.stub.mgt.types.InstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedInstanceList;
import org.wso2.carbon.bpel.stub.mgt.types.VariableInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.Variables_type0;

public class BpelInstanceManagementClient {
    private static final Log log = LogFactory.getLog(BpelInstanceManagementClient.class);
    private static final String EMPTY_STRING = "";
    private static final String INSTANCE_MANAGEMENT_SERVICE = "InstanceManagementService";
    private InstanceManagementServiceStub instanceManagementServiceStub = null;

    public BpelInstanceManagementClient(String serviceEndPoint, String sessionCookie) throws AxisFault {
        String packageMgtServiceUrl = serviceEndPoint + INSTANCE_MANAGEMENT_SERVICE;
        this.instanceManagementServiceStub = new InstanceManagementServiceStub(packageMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.instanceManagementServiceStub);
    }

    public BpelInstanceManagementClient(String serviceEndPoint, String username, String password) throws AxisFault {
        String packageMgtServiceUrl = serviceEndPoint + INSTANCE_MANAGEMENT_SERVICE;
        this.instanceManagementServiceStub = new InstanceManagementServiceStub(packageMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(username, password, (Stub)this.instanceManagementServiceStub);
    }

    public PaginatedInstanceList listAllInstances() throws InstanceManagementException, RemoteException {
        PaginatedInstanceList paginatedInstanceList = null;
        paginatedInstanceList = this.instanceManagementServiceStub.getPaginatedInstanceList(EMPTY_STRING, EMPTY_STRING, 300, 0);
        return paginatedInstanceList;
    }

    public PaginatedInstanceList filterPageInstances(String processId) throws InstanceManagementException, RemoteException {
        PaginatedInstanceList paginatedInstanceList = null;
        PaginatedInstanceList filteredInstanceList = null;
        paginatedInstanceList = this.instanceManagementServiceStub.getPaginatedInstanceList(EMPTY_STRING, EMPTY_STRING, 300, 0);
        filteredInstanceList = new PaginatedInstanceList();
        if (paginatedInstanceList.isInstanceSpecified()) {
            for (LimitedInstanceInfoType instance : paginatedInstanceList.getInstance()) {
                if (!instance.getPid().toString().contains(processId)) continue;
                filteredInstanceList.addInstance(instance);
            }
        }
        return filteredInstanceList;
    }

    public List<String> listInstances() throws InstanceManagementException, RemoteException {
        return this.listInstances(null);
    }

    public List<String> listInstances(int expectedInstanceCount) throws InstanceManagementException, RemoteException {
        return this.listInstances(null, expectedInstanceCount);
    }

    public List<String> listInstances(String processId) throws RemoteException, InstanceManagementException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        PaginatedInstanceList paginatedInstanceList = this.getPaginatedInstanceList(processId, EMPTY_STRING, 300, 0);
        if (paginatedInstanceList.isInstanceSpecified()) {
            for (LimitedInstanceInfoType instance : paginatedInstanceList.getInstance()) {
                instanceIds.add(instance.getIid());
                log.info((Object)("ProcessId: " + instance.getPid() + "\nInstanceId: " + instance.getIid() + "\nStarted: " + instance.getDateStarted().getTime() + "\nState: " + instance.getStatus() + "\nLast-Active: " + instance.getDateLastActive().getTime() + "\n"));
            }
        }
        return instanceIds;
    }

    public List<String> listInstances(String processId, int expectedInstanceCount) throws InstanceManagementException, RemoteException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        PaginatedInstanceList paginatedInstanceList = this.getPaginatedInstanceList(processId, EMPTY_STRING, 300, 0);
        boolean isExpectInstanceFound = false;
        if (paginatedInstanceList.isInstanceSpecified() && paginatedInstanceList.getInstance().length == expectedInstanceCount) {
            isExpectInstanceFound = true;
            for (LimitedInstanceInfoType instance : paginatedInstanceList.getInstance()) {
                instanceIds.add(instance.getIid());
                log.info((Object)("ProcessId: " + instance.getPid() + "\nInstanceId: " + instance.getIid() + "\nStarted: " + instance.getDateStarted().getTime() + "\nState: " + instance.getStatus() + "\nLast-Active: " + instance.getDateLastActive().getTime() + "\n"));
            }
        } else if (!paginatedInstanceList.isInstanceSpecified() && expectedInstanceCount == 0) {
            log.info((Object)"No instances found as expected");
            isExpectInstanceFound = true;
        }
        Assert.assertFalse((!isExpectInstanceFound ? 1 : 0) != 0, (String)("Expected instance count " + expectedInstanceCount + " is not there in the server"));
        return instanceIds;
    }

    private PaginatedInstanceList getPaginatedInstanceList(String processId, String order, int limit, int page) throws InstanceManagementException, RemoteException {
        String filter = processId == null ? EMPTY_STRING : "pid=" + processId;
        return this.instanceManagementServiceStub.getPaginatedInstanceList(filter, order, limit, page);
    }

    public int deleteInstance(String instanceId) throws InstanceManagementException, RemoteException {
        String instanceFilter = "IID=" + instanceId;
        log.info((Object)("Deleting instance " + instanceId));
        return this.instanceManagementServiceStub.deleteInstances(instanceFilter, true);
    }

    public void deleteAllInstances() throws InstanceManagementException, RemoteException {
        log.info((Object)"Deleting all the instances");
        this.instanceManagementServiceStub.deleteInstances(" ", true);
        this.listInstances(0);
    }

    public void clearInstancesOfProcess(String processId) throws InstanceManagementException, RemoteException {
        PaginatedInstanceList instanceList = this.filterPageInstances(processId);
        for (LimitedInstanceInfoType instanceInfo : instanceList.getInstance()) {
            this.deleteInstance(instanceInfo.getIid());
        }
    }

    public InstanceInfoType getInstanceInfo(String instanceId) throws RemoteException, InstanceManagementException {
        InstanceInfoType instanceInfo = null;
        instanceInfo = this.instanceManagementServiceStub.getInstanceInfo(Long.parseLong(instanceId));
        return instanceInfo;
    }

    public void assertStatus(String status, List<String> instanceIds) throws InstanceManagementException, RemoteException {
        for (String iid : instanceIds) {
            InstanceInfoType instanceInfo = this.instanceManagementServiceStub.getInstanceInfo(Long.parseLong(iid));
            if (status == null) continue;
            log.info((Object)("Validating instance status, expected: " + status + " actual: " + instanceInfo.getStatus()));
            Assert.assertFalse((!instanceInfo.getStatus().getValue().equals(status.toUpperCase()) ? 1 : 0) != 0, (String)("Status of instance " + iid + " is not equal to " + status + " but " + instanceInfo.getStatus().getValue()));
        }
    }

    public void assertVariable(String variableName, String expectedVarValue, List<String> instanceIds) throws InstanceManagementException, RemoteException {
        if (variableName != null && instanceIds != null) {
            for (String iid : instanceIds) {
                VariableInfoType[] variableList;
                boolean isVariableFound = false;
                InstanceInfoType instanceInfo = this.instanceManagementServiceStub.getInstanceInfo(Long.parseLong(iid));
                Variables_type0 variables = instanceInfo.getRootScope().getVariables();
                for (VariableInfoType variable : variableList = variables.getVariableInfo()) {
                    String varName = variable.getSelf().getName();
                    if (!varName.equals(variableName)) continue;
                    isVariableFound = true;
                    StringBuffer tempValueBuffer = new StringBuffer();
                    for (OMElement varElement : variable.getValue().getExtraElement()) {
                        tempValueBuffer.append(varElement.toString());
                    }
                    String varValue = tempValueBuffer.toString();
                    if (varValue.contains(expectedVarValue)) continue;
                    Assert.fail((String)("Incorrect Test Result: " + varValue + " Expected" + expectedVarValue + "in the result"));
                }
                Assert.assertFalse((!isVariableFound ? 1 : 0) != 0, (String)(variableName + " variable not found in instance " + iid));
            }
        } else {
            Assert.fail((String)"Test parameters can't be Null");
        }
    }

    public boolean assertInstanceInfo(String status, String variableName, String expectedVarValue, List<String> instanceIds) throws RemoteException, InstanceManagementException {
        boolean variableFound = false;
        for (String iid : instanceIds) {
            VariableInfoType[] variableList;
            InstanceInfoType instanceInfo = this.instanceManagementServiceStub.getInstanceInfo(Long.parseLong(iid));
            if (status != null) {
                log.info((Object)("Validating instance status, expected: " + status + " actual: " + instanceInfo.getStatus()));
            }
            if (variableName == null) {
                variableFound = true;
                continue;
            }
            Variables_type0 variables = instanceInfo.getRootScope().getVariables();
            for (VariableInfoType variable : variableList = variables.getVariableInfo()) {
                String varName = variable.getSelf().getName();
                String varValue = null;
                for (OMElement varElement : variable.getValue().getExtraElement()) {
                    varValue = varValue == null ? varElement.toString() : varValue + varElement.toString();
                    if (expectedVarValue != null) {
                        if (varName.equals(variableName)) {
                            if (varValue.contains(expectedVarValue)) {
                                variableFound = true;
                            } else {
                                log.info((Object)("Incorrect Test Result: " + varValue + " Expected" + expectedVarValue + "in the result"));
                            }
                        }
                    } else {
                        variableFound = true;
                    }
                    log.info((Object)("Variable name: " + varName + "\nVariable Value: " + varValue));
                }
            }
        }
        return variableFound;
    }

    public void performAction(String instanceId, InstanceOperation operation) throws RemoteException, InstanceManagementException {
        switch (operation) {
            case SUSPEND: {
                this.instanceManagementServiceStub.suspendInstance(Long.parseLong(instanceId));
                break;
            }
            case RESUME: {
                this.instanceManagementServiceStub.resumeInstance(Long.parseLong(instanceId));
                break;
            }
            case TERMINATE: {
                this.instanceManagementServiceStub.terminateInstance(Long.parseLong(instanceId));
            }
        }
    }

    public static enum InstanceOperation {
        SUSPEND,
        RESUME,
        TERMINATE;

    }
}

