/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.bpel;

import java.rmi.RemoteException;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.carbon.bpel.stub.mgt.BPELPackageManagementServiceStub;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.DeployedPackagesPaginated;
import org.wso2.carbon.bpel.stub.mgt.types.PackageType;
import org.wso2.carbon.bpel.stub.upload.types.UploadedFileItem;

public class BpelPackageManagementClient {
    private static final Log log = LogFactory.getLog(BpelPackageManagementClient.class);
    private static final String BPEL_PACKAGE_MANAGEMENT_SERVICE = "BPELPackageManagementService";
    private BPELPackageManagementServiceStub bpelPackageManagementServiceStub;

    public BpelPackageManagementClient(String serviceEndPoint, String sessionCookie) throws AxisFault {
        String packageMgtServiceUrl = serviceEndPoint + BPEL_PACKAGE_MANAGEMENT_SERVICE;
        this.bpelPackageManagementServiceStub = new BPELPackageManagementServiceStub(packageMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.bpelPackageManagementServiceStub);
    }

    public BpelPackageManagementClient(String serviceEndPoint, String username, String password) throws AxisFault {
        String packageMgtServiceUrl = serviceEndPoint + BPEL_PACKAGE_MANAGEMENT_SERVICE;
        BPELPackageManagementServiceStub packageManagementServiceStub = null;
        packageManagementServiceStub = new BPELPackageManagementServiceStub(packageMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(username, password, (Stub)packageManagementServiceStub);
    }

    private UploadedFileItem getUploadedFileItem(DataHandler dataHandler, String fileName, String fileType) {
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        uploadedFileItem.setDataHandler(dataHandler);
        uploadedFileItem.setFileName(fileName);
        uploadedFileItem.setFileType(fileType);
        return uploadedFileItem;
    }

    public void undeployBPEL(int page, String packageName) throws PackageManagementException, RemoteException, InterruptedException {
        this.bpelPackageManagementServiceStub.undeployBPELPackage(packageName);
        Thread.sleep(10000L);
        DeployedPackagesPaginated deployedPackages = this.bpelPackageManagementServiceStub.listDeployedPackagesPaginated(page, packageName);
        boolean packageUndeployed = true;
        try {
            for (PackageType bpelPackage : deployedPackages.get_package()) {
                if (!bpelPackage.getName().equals(packageName)) continue;
                packageUndeployed = false;
                log.error((Object)"Service still exists, Undeployment failed");
            }
        }
        catch (NullPointerException e) {
            log.info((Object)(packageName + " has undeployed successfully"));
        }
    }

    public void undeployBPEL(String packageName) throws PackageManagementException, RemoteException, InterruptedException {
        this.bpelPackageManagementServiceStub.undeployBPELPackage(packageName);
        Thread.sleep(10000L);
        DeployedPackagesPaginated deployedPackages = this.bpelPackageManagementServiceStub.listDeployedPackagesPaginated(1, packageName);
        boolean packageUndeployed = true;
        try {
            for (PackageType bpelPackage : deployedPackages.get_package()) {
                if (!bpelPackage.getName().equals(packageName)) continue;
                packageUndeployed = false;
                log.error((Object)"Service still exists, Undeployment failed");
            }
        }
        catch (NullPointerException e) {
            log.info((Object)(packageName + " has undeployed successfully"));
        }
    }

    public boolean checkProcessDeployment(int pageNumber, String packageName) throws RemoteException, PackageManagementException {
        boolean packageDeployed = false;
        for (int page = 0; page <= 20; ++page) {
            DeployedPackagesPaginated deployedPackages = this.bpelPackageManagementServiceStub.listDeployedPackagesPaginated(pageNumber, packageName);
            packageDeployed = false;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (PackageType bpelPackage : deployedPackages.get_package()) {
                if (!bpelPackage.getName().equals(packageName)) continue;
                log.info((Object)(packageName + " has deployed successfully"));
                packageDeployed = true;
            }
            if (packageDeployed) break;
        }
        return packageDeployed;
    }
}

