/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.bpel;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.carbon.bpel.stub.mgt.ProcessManagementException;
import org.wso2.carbon.bpel.stub.mgt.ProcessManagementServiceStub;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedProcessInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedProcessInfoList;
import org.wso2.carbon.bpel.stub.mgt.types.ProcessInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.ProcessStatus;

public class BpelProcessManagementClient {
    private static final Log log = LogFactory.getLog(BpelProcessManagementClient.class);
    private static final String PROCESS_MANAGEMENT_SERVICE = "ProcessManagementService";
    private ProcessManagementServiceStub processManagementServiceStub = null;

    public BpelProcessManagementClient(String serviceEndPoint, String sessionCookie) throws AxisFault {
        String serviceMgtServiceUrl = serviceEndPoint + PROCESS_MANAGEMENT_SERVICE;
        this.processManagementServiceStub = new ProcessManagementServiceStub(serviceMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.processManagementServiceStub);
    }

    public BpelProcessManagementClient(String serviceEndPoint, String username, String password) throws AxisFault {
        String serviceMgtServiceUrl = serviceEndPoint + PROCESS_MANAGEMENT_SERVICE;
        this.processManagementServiceStub = new ProcessManagementServiceStub(serviceMgtServiceUrl);
        AuthenticateStubUtil.authenticateStub(username, password, (Stub)this.processManagementServiceStub);
    }

    public void setStatus(String processID, String status) throws RemoteException, ProcessManagementException {
        if (ProcessStatus.ACTIVE.getValue().equals(status.toUpperCase())) {
            this.processManagementServiceStub.activateProcess(QName.valueOf(processID));
        } else if (ProcessStatus.RETIRED.getValue().equals(status.toUpperCase())) {
            this.processManagementServiceStub.retireProcess(QName.valueOf(processID));
        }
    }

    public String getStatus(String processID) throws RemoteException, ProcessManagementException {
        String status = null;
        ProcessInfoType processInfo = this.processManagementServiceStub.getProcessInfo(QName.valueOf(processID));
        status = processInfo.getStatus().getValue().toString();
        return status;
    }

    public String getProcessId(String packageName) throws RemoteException, ProcessManagementException {
        String processId = null;
        String[] processList = this.processManagementServiceStub.getAllProcesses("y");
        if (processList != null) {
            if (processList.length == 0) {
                throw new AssertionError((Object)"Process list cannot be empty");
            }
            for (String id : processList) {
                if (!id.contains(packageName + "-")) continue;
                processId = id;
            }
        }
        return processId;
    }

    public PaginatedProcessInfoList getProcessInfo(String packageName) throws RemoteException, ProcessManagementException {
        PaginatedProcessInfoList filteredProcess = new PaginatedProcessInfoList();
        String processFilter = "name}}* namespace=*";
        String processListOrderBy = "-deployed";
        PaginatedProcessInfoList processes = this.processManagementServiceStub.getPaginatedProcessList("name}}* namespace=*", "-deployed", 0);
        for (LimitedProcessInfoType processInfo : processes.getProcessInfo()) {
            if (!processInfo.getPid().contains(packageName + "-")) continue;
            filteredProcess.addProcessInfo(processInfo);
        }
        return filteredProcess;
    }

    public List<String> getProcessInfoList(String packageName) throws RemoteException, ProcessManagementException {
        String[] processList;
        LinkedList<String> filteredProcess = new LinkedList<String>();
        for (String id : processList = this.processManagementServiceStub.getAllProcesses("y")) {
            if (!id.contains(packageName + "-")) continue;
            filteredProcess.add(id);
        }
        return filteredProcess;
    }
}

