/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.bpel;

import java.io.File;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.upload.BPELUploaderStub;
import org.wso2.carbon.bpel.stub.upload.types.UploadedFileItem;

public class BpelUploaderClient {
    private static final Log log = LogFactory.getLog(BpelUploaderClient.class);
    private static final String serviceName = "BPELUploader";
    private BPELUploaderStub bpelUploaderStub;

    public BpelUploaderClient(String serviceEndPoint, String sessionCookie) throws AxisFault {
        String uploaderServiceURL = serviceEndPoint + serviceName;
        this.bpelUploaderStub = new BPELUploaderStub(uploaderServiceURL);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.bpelUploaderStub);
    }

    public BpelUploaderClient(String serviceEndPoint, String username, String password) throws AxisFault {
        String uploaderServiceURL = serviceEndPoint + serviceName;
        this.bpelUploaderStub = new BPELUploaderStub(uploaderServiceURL);
        AuthenticateStubUtil.authenticateStub(username, password, (Stub)this.bpelUploaderStub);
    }

    public boolean deployBPEL(String packageName, String dirPath) throws RemoteException, InterruptedException, PackageManagementException {
        boolean success = false;
        this.deployPackage(packageName, dirPath, this.bpelUploaderStub);
        return success;
    }

    private UploadedFileItem getUploadedFileItem(DataHandler dataHandler, String fileName, String fileType) {
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        uploadedFileItem.setDataHandler(dataHandler);
        uploadedFileItem.setFileName(fileName);
        uploadedFileItem.setFileType(fileType);
        return uploadedFileItem;
    }

    private void deployPackage(String packageName, String resourceDir, BPELUploaderStub bpelUploaderStub) throws RemoteException, InterruptedException {
        String sampleArchiveName = packageName + ".zip";
        log.info((Object)(resourceDir + File.separator + sampleArchiveName));
        FileDataSource bpelDataSource = new FileDataSource(resourceDir + File.separator + sampleArchiveName);
        UploadedFileItem[] uploadedFileItems = new UploadedFileItem[]{this.getUploadedFileItem(new DataHandler((DataSource)bpelDataSource), sampleArchiveName, "zip")};
        log.info((Object)("Deploying " + sampleArchiveName));
        bpelUploaderStub.uploadService(uploadedFileItems);
    }
}

