/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.clients.humantasks;

import java.io.File;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.AuthenticateStubUtil;
import org.wso2.carbon.humantask.stub.mgt.PackageManagementException;
import org.wso2.carbon.humantask.stub.upload.HumanTaskUploaderStub;
import org.wso2.carbon.humantask.stub.upload.types.UploadedFileItem;

public class HumanTaskUploaderClient {
    private static final Log log = LogFactory.getLog(HumanTaskUploaderClient.class);
    private static final String serviceName = "HumanTaskUploader";
    private HumanTaskUploaderStub htUploaderStub;

    public HumanTaskUploaderClient(String serviceEndPoint, String sessionCookie) throws AxisFault {
        String uploaderServiceURL = serviceEndPoint + serviceName;
        this.htUploaderStub = new HumanTaskUploaderStub(uploaderServiceURL);
        AuthenticateStubUtil.authenticateStub(sessionCookie, (Stub)this.htUploaderStub);
    }

    public HumanTaskUploaderClient(String serviceEndPoint, String username, String password) throws AxisFault {
        String uploaderServiceURL = serviceEndPoint + serviceName;
        this.htUploaderStub = new HumanTaskUploaderStub(uploaderServiceURL);
        AuthenticateStubUtil.authenticateStub(username, password, (Stub)this.htUploaderStub);
    }

    public boolean deployHumantask(String packageName, String dirPath) throws RemoteException, InterruptedException, PackageManagementException {
        boolean success = false;
        this.deployPackage(packageName, dirPath, this.htUploaderStub);
        return success;
    }

    private UploadedFileItem getUploadedFileItem(DataHandler dataHandler, String fileName, String fileType) {
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        uploadedFileItem.setDataHandler(dataHandler);
        uploadedFileItem.setFileName(fileName);
        uploadedFileItem.setFileType(fileType);
        return uploadedFileItem;
    }

    private void deployPackage(String packageName, String resourceDir, HumanTaskUploaderStub htUploaderStub) throws RemoteException, InterruptedException {
        String sampleArchiveName = packageName + ".zip";
        log.info((Object)(resourceDir + File.separator + sampleArchiveName));
        FileDataSource humantaskDataSource = new FileDataSource(resourceDir + File.separator + sampleArchiveName);
        UploadedFileItem[] uploadedFileItems = new UploadedFileItem[]{this.getUploadedFileItem(new DataHandler((DataSource)humantaskDataSource), sampleArchiveName, "zip")};
        log.info((Object)("Deploying " + sampleArchiveName));
        htUploaderStub.uploadHumanTask(uploadedFileItems);
    }
}

