/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.utils;

import java.io.File;
import java.rmi.RemoteException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.bps.integration.common.clients.bpel.BpelUploaderClient;
import org.wso2.bps.integration.common.clients.bpmn.BPMNUploaderClient;
import org.wso2.bps.integration.common.clients.humantasks.HumanTaskUploaderClient;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.integration.common.admin.client.SecurityAdminServiceClient;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;

public class BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPSMasterTest.class);
    protected AutomationContext bpsServer;
    protected String sessionCookie = null;
    protected String backEndUrl = null;
    protected String serviceUrl = null;
    protected SecurityAdminServiceClient securityAdminServiceClient;
    protected BpelUploaderClient bpelUploaderClient;
    protected HumanTaskUploaderClient humanTaskUploaderClient;
    protected BPMNUploaderClient bpmnUploaderClient;
    protected LoginLogoutClient loginLogoutClient;

    protected void init(TestUserMode testUserMode) throws Exception {
        this.bpsServer = new AutomationContext("BPS", testUserMode);
        this.loginLogoutClient = new LoginLogoutClient(this.bpsServer);
        this.sessionCookie = this.loginLogoutClient.login();
        this.backEndUrl = this.bpsServer.getContextUrls().getBackEndUrl();
        this.serviceUrl = this.bpsServer.getContextUrls().getServiceUrl();
        this.bpelUploaderClient = new BpelUploaderClient(this.backEndUrl, this.sessionCookie);
        this.humanTaskUploaderClient = new HumanTaskUploaderClient(this.backEndUrl, this.sessionCookie);
        this.bpmnUploaderClient = new BPMNUploaderClient(this.backEndUrl, this.sessionCookie);
    }

    protected void init() throws Exception {
        this.bpsServer = new AutomationContext("BPS", TestUserMode.SUPER_TENANT_ADMIN);
        this.loginLogoutClient = new LoginLogoutClient(this.bpsServer);
        this.sessionCookie = this.loginLogoutClient.login();
        this.backEndUrl = this.bpsServer.getContextUrls().getBackEndUrl();
        this.serviceUrl = this.bpsServer.getContextUrls().getServiceUrl();
        this.bpelUploaderClient = new BpelUploaderClient(this.backEndUrl, this.sessionCookie);
        this.humanTaskUploaderClient = new HumanTaskUploaderClient(this.backEndUrl, this.sessionCookie);
        this.bpmnUploaderClient = new BPMNUploaderClient(this.backEndUrl, this.sessionCookie);
    }

    protected void init(String domainKey, String userKey) throws Exception {
        this.bpsServer = new AutomationContext("BPS", "bpsServerInstance0001", domainKey, userKey);
        this.loginLogoutClient = new LoginLogoutClient(this.bpsServer);
        this.sessionCookie = this.loginLogoutClient.login();
        this.backEndUrl = this.bpsServer.getContextUrls().getBackEndUrl();
        this.serviceUrl = this.bpsServer.getContextUrls().getServiceUrl();
        this.bpelUploaderClient = new BpelUploaderClient(this.backEndUrl, this.sessionCookie);
        this.humanTaskUploaderClient = new HumanTaskUploaderClient(this.backEndUrl, this.sessionCookie);
        this.bpmnUploaderClient = new BPMNUploaderClient(this.backEndUrl, this.sessionCookie);
    }

    protected void uploadBpelForTest(String bpelFileName) throws Exception {
        String dirPath = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "bpel";
        this.uploadBpelForTest(bpelFileName, dirPath);
    }

    protected void uploadBpelForTest(String bpelPackageName, String artifactLocation) throws RemoteException, InterruptedException, PackageManagementException {
        this.bpelUploaderClient.deployBPEL(bpelPackageName, artifactLocation);
    }

    protected void uploadHumanTaskForTest(String humantaskName) throws Exception {
        this.uploadHumanTaskForTest(humantaskName, FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "humantask");
    }

    protected void uploadBPMNForTest(String bpmnPackageNam) throws Exception {
        this.uploadBPMNForTest(bpmnPackageNam, FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "bpmn");
    }

    protected void uploadHumanTaskForTest(String taskPackageName, String taskPackageLocation) throws InterruptedException, RemoteException, org.wso2.carbon.humantask.stub.mgt.PackageManagementException {
        this.humanTaskUploaderClient.deployHumantask(taskPackageName, taskPackageLocation);
    }

    protected void uploadBPMNForTest(String taskPackageName, String taskPackageLocation) throws InterruptedException, RemoteException, org.wso2.carbon.humantask.stub.mgt.PackageManagementException {
        this.bpmnUploaderClient.deployBPMN(taskPackageName, taskPackageLocation);
    }

    protected String getServiceUrl(String serviceName) throws XPathExpressionException {
        return this.bpsServer.getContextUrls().getServiceUrl() + "/" + serviceName;
    }
}

