/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;

public class RequestSender {
    private static final Log log = LogFactory.getLog(RequestSender.class);
    public static final boolean TWO_WAY = true;
    public static final boolean ONE_WAY = false;

    public static OMElement sendRequest(String payloadStr, EndpointReference targetEPR) throws XMLStreamException, AxisFault {
        OMElement payload = AXIOMUtil.stringToOM((String)payloadStr);
        Options options = new Options();
        options.setTo(targetEPR);
        ServiceClient sender = new ServiceClient();
        sender.setOptions(options);
        log.info((Object)("Request: " + payload.toString()));
        OMElement result = sender.sendReceive(payload);
        log.info((Object)("Response: " + result.toString()));
        return result;
    }

    public void sendRequest(String eprUrl, String operation, String payload, int numberOfInstances, List<String> expectedStrings, boolean twoWay) throws Exception {
        this.waitForProcessDeployment(eprUrl);
        for (int i = 0; i < numberOfInstances; ++i) {
            EndpointReference epr = new EndpointReference(eprUrl + "/" + operation);
            if (twoWay) {
                OMElement result = RequestSender.sendRequest(payload, epr);
                if (expectedStrings == null) continue;
                for (String expectedString : expectedStrings) {
                    Assert.assertFalse((!result.toString().contains(expectedString) ? 1 : 0) != 0);
                }
                continue;
            }
            this.sendRequestOneWay(payload, epr);
        }
    }

    public void sendRequestOneWay(String payloadStr, EndpointReference targetEPR) throws XMLStreamException, AxisFault {
        OMElement payload = AXIOMUtil.stringToOM((String)payloadStr);
        Options options = new Options();
        options.setTo(targetEPR);
        ServiceClient sender = new ServiceClient();
        sender.setOptions(options);
        log.info((Object)("Request: " + payload.toString()));
        sender.fireAndForget(payload);
    }

    public boolean isServiceAvailable(String serviceUrl) {
        InputStream wsdlIS;
        URL wsdlURL;
        try {
            wsdlURL = new URL(serviceUrl + "?wsdl");
        }
        catch (MalformedURLException e) {
            return false;
        }
        try {
            wsdlIS = wsdlURL.openStream();
        }
        catch (IOException e) {
            return false;
        }
        if (wsdlIS != null) {
            String wsdl;
            int read;
            byte[] bLine = new byte[1024];
            try {
                read = wsdlIS.read(bLine);
            }
            catch (IOException e) {
                return false;
            }
            return read > 0 && (wsdl = new String(bLine)).contains("definitions");
        }
        return false;
    }

    public void waitForProcessDeployment(String serviceUrl) throws Exception {
        int serviceTimeOut = 0;
        while (!this.isServiceAvailable(serviceUrl)) {
            if (serviceTimeOut == 0) {
                log.info((Object)("Waiting for the " + serviceUrl + "."));
            } else if (serviceTimeOut > 200) {
                log.error((Object)"Time out");
                throw new Exception(serviceUrl + " service is not found");
            }
            try {
                ++serviceTimeOut;
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void assertRequest(String eprUrl, String operation, String payload, int numberOfInstances, String expectedException, boolean twoWay) throws XMLStreamException, AxisFault {
        for (int i = 0; i < numberOfInstances; ++i) {
            OMElement result;
            block8: {
                result = null;
                try {
                    EndpointReference epr = new EndpointReference(eprUrl + "/" + operation);
                    if (twoWay) {
                        result = RequestSender.sendRequest(payload, epr);
                    } else {
                        this.sendRequestOneWay(payload, epr);
                    }
                }
                catch (XMLStreamException e) {
                    if (!e.getClass().getSimpleName().equals(expectedException)) {
                        throw new XMLStreamException(e);
                    }
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error occurred while sending request.", (Throwable)axisFault);
                    if (((Object)((Object)axisFault)).getClass().getSimpleName().equals(expectedException)) break block8;
                    throw new AxisFault(axisFault.getMessage());
                }
            }
            assert (result != null);
            if (result.toString().contains(expectedException)) continue;
            Assert.fail((String)"Expected response not found");
        }
    }
}

