/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELFunctionalityTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELFunctionalityTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.bpelactivities"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestAlarm");
        this.uploadBpelForTest("DynPartner");
        this.uploadBpelForTest("TestForEach");
        this.uploadBpelForTest("TestPickOneWay");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "PickService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="onAlarm BPEL functionality test case")
    public void processProperty() throws AxisFault, XMLStreamException {
        String payload = "<exam:start xmlns:exam=\"http://ode.apache.org/example\">4</exam:start>";
        String operation = "receive";
        String serviceName = "CanonicServiceForClient";
        String expectedOutput = "start";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="Dynamic Partner Links and Dynamic Addressing in BPEL")
    public void dynamicPartner() throws AxisFault, XMLStreamException {
        String payload = "<ns2:dummy xmlns:ns2=\"http://ode/bpel/responder.wsdl\">fire!</ns2:dummy>";
        String operation = "execute";
        String serviceName = "DynMainService";
        String expectedOutput = "OK";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="forEach BPEL functionality test case")
    public void forEach() throws AxisFault, XMLStreamException {
        String payload = "<jms:input xmlns:jms=\"http://www.example.org/jms\">testIf</jms:input>";
        String operation = "start";
        String serviceName = "ForEachService";
        String expectedOutput = "testIf123";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="Pick BPEL functionality test case")
    public void pick() throws AxisFault, XMLStreamException {
        String payload = "<pic:dealDeck xmlns:pic=\"http://www.stark.com/PickService\">         <pic:Deck>testPick</pic:Deck>      </pic:dealDeck>";
        String operation = "dealDeck";
        String serviceName = "PickService";
        String expectedOutput = "testPick";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
        payload = "<pic:pickClub xmlns:pic=\"http://www.stark.com/PickService\">         <pic:Deck>testPick</pic:Deck>      </pic:pickClub>";
        operation = "pickClub";
        serviceName = "PickService";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestAlarm");
        this.bpelPackageManagementClient.undeployBPEL("DynPartner");
        this.bpelPackageManagementClient.undeployBPEL("TestForEach");
        this.bpelPackageManagementClient.undeployBPEL("TestPickOneWay");
        this.loginLogoutClient.logout();
    }
}

