/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelmanagement;

import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.InstanceManagementException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.ProcessManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedInstanceList;

public class BpelInstanceManagementTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelInstanceManagementTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient = null;
    BpelProcessManagementClient bpelProcessManagementClient = null;
    BpelInstanceManagementClient bpelInstanceManagementClient = null;
    RequestSender requestSender = null;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestPickOneWay");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "PickService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.manage"}, description="Set service to Active State", priority=1)
    public void testCreateInstance() throws InterruptedException, XMLStreamException, RemoteException, ProcessManagementException, InstanceManagementException, LoginAuthenticationExceptionException {
        EndpointReference epr = new EndpointReference(this.backEndUrl + "PickService");
        RequestSender.sendRequest((String)"<pic:dealDeck xmlns:pic=\"http://www.stark.com/PickService\">   <pic:Deck>testPick</pic:Deck></pic:dealDeck>", (EndpointReference)epr);
        PaginatedInstanceList instanceList = this.bpelInstanceManagementClient.filterPageInstances(this.bpelProcessManagementClient.getProcessId("PickProcess"));
        this.instanceInfo = instanceList.getInstance()[0];
        if (instanceList.getInstance().length == 0) {
            Assert.fail((String)"Instance failed to create");
        }
    }

    @Test(groups={"wso2.bps", "wso2.bps.manage"}, description="Suspends The Service", dependsOnMethods={"testCreateInstance"}, singleThreaded=true)
    public void testSuspendInstance() throws InterruptedException, InstanceManagementException, RemoteException, LoginAuthenticationExceptionException {
        this.bpelInstanceManagementClient.performAction(this.instanceInfo.getIid(), BpelInstanceManagementClient.InstanceOperation.SUSPEND);
        Assert.assertTrue((boolean)this.bpelInstanceManagementClient.getInstanceInfo(this.instanceInfo.getIid()).getStatus().getValue().equals("SUSPENDED"), (String)"The Service Is not Suspended");
    }

    @Test(groups={"wso2.bps", "wso2.bps.manage"}, description="Resume The Service", dependsOnMethods={"testSuspendInstance"}, singleThreaded=true)
    public void testResumeInstance() throws InterruptedException, InstanceManagementException, RemoteException, LoginAuthenticationExceptionException {
        this.bpelInstanceManagementClient.performAction(this.instanceInfo.getIid(), BpelInstanceManagementClient.InstanceOperation.RESUME);
        Assert.assertTrue((boolean)this.bpelInstanceManagementClient.getInstanceInfo(this.instanceInfo.getIid()).getStatus().getValue().equals("ACTIVE"), (String)"The Service Is not Suspended");
    }

    @Test(groups={"wso2.bps", "wso2.bps.manage"}, description="Terminate The Service", dependsOnMethods={"testResumeInstance"}, singleThreaded=true)
    public void testTerminateInstance() throws InterruptedException, InstanceManagementException, RemoteException, LoginAuthenticationExceptionException {
        this.bpelInstanceManagementClient.performAction(this.instanceInfo.getIid(), BpelInstanceManagementClient.InstanceOperation.TERMINATE);
        Assert.assertTrue((boolean)this.bpelInstanceManagementClient.getInstanceInfo(this.instanceInfo.getIid()).getStatus().getValue().equals("TERMINATED"), (String)"The Service Is not Terminated");
    }

    @Test(groups={"wso2.bps", "wso2.bps.manage"}, description="Delete the instance", dependsOnMethods={"testTerminateInstance"})
    public void testDeleteInstance() throws InterruptedException, InstanceManagementException, RemoteException, LoginAuthenticationExceptionException {
        this.bpelInstanceManagementClient.deleteInstance(this.instanceInfo.getIid());
        Thread.sleep(5000L);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LoginAuthenticationExceptionException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestPickOneWay");
        this.loginLogoutClient.logout();
    }
}

