/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.stucturedactivities;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.InstanceManagementException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.ProcessManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedInstanceList;

public class BpelStructActionIfClient
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelStructActionIfClient.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;
    private String processID;
    private PaginatedInstanceList instanceList;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws InterruptedException, RemoteException, Exception, MalformedURLException, PackageManagementException, ProcessManagementException, LoginAuthenticationExceptionException {
        this.setEnvironment();
        this.uploadBpelForTest("TestIf");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "TestIf");
        this.processID = this.bpelProcessManagementClient.getProcessId("TestIf");
    }

    @Test(groups={"wso2.bps", "wso2.bps.structures"}, description="Deploys Bpel with If activity", priority=1)
    public void testTrue() throws Exception, RemoteException {
        int instanceCount = 0;
        this.instanceList = new PaginatedInstanceList();
        this.instanceList = this.bpelInstanceManagementClient.filterPageInstances(this.processID);
        if (this.instanceList.getInstance() != null) {
            instanceCount = this.instanceList.getInstance().length;
        }
        if (!this.processID.isEmpty()) {
            try {
                this.ifTrueRequest();
                Thread.sleep(5000L);
                if (instanceCount >= this.bpelInstanceManagementClient.filterPageInstances(this.processID).getInstance().length) {
                    Assert.fail((String)"Instance is not created for the request");
                }
            }
            catch (InterruptedException e) {
                log.error((Object)("Process management failed" + e));
                Assert.fail((String)("Process management failed" + e));
            }
        }
        this.bpelInstanceManagementClient.clearInstancesOfProcess(this.processID);
    }

    @Test(groups={"wso2.bps", "wso2.bps.structures"}, description="Deploys Bpel with If activity", priority=2)
    public void testFalse() throws Exception, RemoteException {
        int instanceCount = 0;
        this.instanceList = new PaginatedInstanceList();
        this.instanceList = this.bpelInstanceManagementClient.filterPageInstances(this.processID);
        if (this.instanceList.getInstance() != null) {
            instanceCount = this.instanceList.getInstance().length;
        }
        if (!this.processID.isEmpty()) {
            try {
                this.ifFalseRequest();
                Thread.sleep(5000L);
                if (instanceCount >= this.bpelInstanceManagementClient.filterPageInstances(this.processID).getInstance().length) {
                    Assert.fail((String)"Instance is not created for the request");
                }
            }
            catch (InterruptedException e) {
                log.error((Object)("Process management failed" + e));
                Assert.fail((String)("Process management failed" + e));
            }
        }
        this.bpelInstanceManagementClient.clearInstancesOfProcess(this.processID);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws InstanceManagementException, RemoteException, PackageManagementException, InterruptedException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestIf");
        this.loginLogoutClient.logout();
    }

    public void ifTrueRequest() throws Exception {
        String payload = "<un:hello xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><TestPart>2.0</TestPart></un:hello>";
        String operation = "hello";
        String serviceName = "TestIf";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add(">Worked<");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    public void ifFalseRequest() throws Exception {
        String payload = "<un:hello xmlns:un=\"http://ode/bpel/unit-test.wsdl\"><TestPart>1.0</TestPart></un:hello>";
        String operation = "hello";
        String serviceName = "TestIf";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add(">Failed<");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }
}

