/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.upload;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedInstanceList;

public class BpelInMemoryDeploymentTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelInMemoryDeploymentTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("CustomerInfo");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "CustomerInfoService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.deployment"}, description="Tests uploading Bpel Service with In memory", priority=0)
    public void testInmemoryUolpad() throws Exception {
        this.bpelProcessManagementClient.getStatus(this.bpelProcessManagementClient.getProcessId("CustomerInfo"));
        RequestSender requestSender = new RequestSender();
        requestSender.waitForProcessDeployment(this.backEndUrl + "CustomerInfoService");
        requestSender.assertRequest(this.backEndUrl + "CustomerInfoService", "getCustomerSSN", "<p:CustomerInfo xmlns:p=\"http://wso2.org/bps/samples/loan_process/schema\">\n      <!--Exactly 1 occurrence-->\n      <Name xmlns=\"http://wso2.org/bps/samples/loan_process/schema\">Dharshana</Name>\n      <!--Exactly 1 occurrence-->\n      <Email xmlns=\"http://wso2.org/bps/samples/loan_process/schema\">dharshanaw@wso2.com</Email>\n      <!--Exactly 1 occurrence-->\n      <tns:CustomerID xmlns:tns=\"http://wso2.org/bps/samples/loan_process/schema\">?</tns:CustomerID>\n      <!--Exactly 1 occurrence-->\n      <CreditRating xmlns=\"http://wso2.org/bps/samples/loan_process/schema\">?</CreditRating>\n   </p:CustomerInfo>\n", 1, "43235678SSN", true);
        PaginatedInstanceList instanceList = this.bpelInstanceManagementClient.filterPageInstances(this.bpelProcessManagementClient.getProcessId("CustomerInfo"));
        Assert.assertTrue((instanceList != null ? 1 : 0) != 0, (String)"Service is not running inmemory");
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("CustomerInfo");
        this.loginLogoutClient.logout();
    }
}

