/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELBasicActivitiesTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELBasicActivitiesTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.bpelactivities"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestIf");
        this.uploadBpelForTest("HelloWorld2");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "HelloService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="Hello World test case", priority=0)
    public void helloWorld() throws InterruptedException, RemoteException, PackageManagementException, MalformedURLException, XMLStreamException {
        String payLoad = " <p:hello xmlns:p=\"http://ode/bpel/unit-test.wsdl\">\n      <!--Exactly 1 occurrence--><TestPart>test</TestPart>\n   </p:hello>";
        String operation = "hello";
        String serviceName = "HelloService";
        String expectedBefore = "World";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payLoad, 1, expectedBefore, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="if true test case")
    public void ifTrue() throws XMLStreamException, InterruptedException, AxisFault {
        String payLoad = " <p:hello xmlns:p=\"http://ode/bpel/unit-test.wsdl\">\n      <!--Exactly 1 occurrence-->\n      <TestPart>2.00</TestPart>\n   </p:hello>";
        String operation = "hello";
        String serviceName = "TestIf";
        String expectedBefore = "Worked";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payLoad, 1, expectedBefore, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="if false test case")
    public void ifFalse() throws XMLStreamException, InterruptedException, AxisFault {
        String payLoad = " <p:hello xmlns:p=\"http://ode/bpel/unit-test.wsdl\">\n      <!--Exactly 1 occurrence-->\n      <TestPart>1.00</TestPart>\n   </p:hello>";
        String operation = "hello";
        String serviceName = "TestIf";
        String expectedBefore = "Failed";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payLoad, 1, expectedBefore, true);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("HelloWorld2");
        this.bpelPackageManagementClient.undeployBPEL("TestIf");
        this.loginLogoutClient.logout();
    }
}

