/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELMessageRoutingTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELMessageRoutingTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.bpelactivities"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestCorrelationUnique");
        this.uploadBpelForTest("MyRoleMexTestProcess");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "MyRoleMexTestProcessService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="correlation opaque init foo in message routing test")
    private void correlationOpaqueInitFoo() throws Exception {
        String payload = "<un:init xmlns:un=\"http://example.com/bpel/counter\"><name>foo</name><alias>foo.alias</alias></un:init>";
        String operation = "init";
        String serviceName = "counterService2";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("initResponse");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="correlation opaque get bar in message routing test", dependsOnMethods={"correlationOpaqueGetAndIncrementFoo"})
    private void correlationOpaqueGetBar() throws Exception {
        String payload = "<un:get xmlns:un=\"http://example.com/bpel/counter\"><name>bar</name><alias>get.alias</alias></un:get>";
        String operation = "get";
        String serviceName = "counterService2";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("<name>get.alias</name>");
        expectedOutput.add("<value>0.0</value>");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    private void correlationOpaqueGetBarFault() throws XMLStreamException, AxisFault {
        String payload = "<un:get xmlns:un=\"http://example.com/bpel/counter\"><name>bar</name><alias>get.alias</alias></un:get>";
        String operation = "get";
        String serviceName = "counterService2";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, "AxisFault", true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="correlation opaque init bar in message routing test", dependsOnMethods={"correlationOpaqueInitFoo"})
    private void correlationOpaqueInitBar() throws Exception {
        String payload = "<un:init xmlns:un=\"http://example.com/bpel/counter\"><name>bar</name><alias>bar.alias</alias></un:init>";
        String operation = "init";
        String serviceName = "counterService2";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("initResponse");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="correlation opaque get and increment foo in message routing test", dependsOnMethods={"correlationOpaqueInitBar"})
    private void correlationOpaqueGetAndIncrementFoo() throws Exception {
        String payload = "<un:getAndIncrement xmlns:un=\"http://example.com/bpel/counter\"><name>foo</name><alias>incr.alias</alias></un:getAndIncrement>";
        String operation = "getAndIncrement";
        String serviceName = "counterService2";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("<name>foo</name>");
        expectedOutput.add("<value>0.0</value>");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    private void correlationOpaqueGetAndIncrementFooFault() throws XMLStreamException, AxisFault {
        String payload = "<un:getAndIncrement xmlns:un=\"http://example.com/bpel/counter\"><name>foo</name><alias>incr.alias</alias></un:getAndIncrement>";
        String operation = "getAndIncrement";
        String serviceName = "counterService2";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, "AxisFault", true);
    }

    private void correlationOpaqueInitFooFault() throws XMLStreamException, AxisFault {
        String payload = "<un:init xmlns:un=\"http://example.com/bpel/counter\"><name>foo</name><alias>foo.alias</alias></un:init>";
        String operation = "init";
        String serviceName = "counterService2";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payload, 1, "AxisFault", true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="my Role MEX retention in message routing test", dependsOnMethods={"correlationOpaqueGetBar"})
    private void myRoleMEXRetention() throws Exception {
        String payload = "<sam:MyRoleMexTestProcessRequest xmlns:sam=\"http://wso2.org/bpel/sample\"><sam:input>test</sam:input></sam:MyRoleMexTestProcessRequest>";
        String operation = "init";
        String serviceName = "MyRoleMexTestProcessService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add(">test<");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
        payload = "<sam:process xmlns:sam=\"http://wso2.org/bpel/sample\"><sam:in>test</sam:in></sam:process>";
        operation = "process";
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestCorrelationUnique");
        this.bpelPackageManagementClient.undeployBPEL("MyRoleMexTestProcess");
        this.loginLogoutClient.logout();
    }
}

