/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELStructuredActivitiesTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELStructuredActivitiesTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.bpelactivities"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestForEach");
        this.uploadBpelForTest("TestPickOneWay");
        this.uploadBpelForTest("TestFlowLinks");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "FlowLinkTest");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="for each in structured activities", dependsOnMethods={"flowLinks"})
    private void forEach() throws Exception {
        String payload = "<input xmlns=\"http://www.example.org/jms\">in</input>";
        String operation = "start";
        String serviceName = "ForEachService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("123");
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="flow links in structured activities")
    private void flowLinks() throws Exception {
        String payload = "<ns1:ExecuteWorkflow xmlns:ns1=\"workflowns\"><value>foo</value></ns1:ExecuteWorkflow>";
        String operation = "ExecuteWorkflow";
        String serviceName = "FlowLinkTest";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("foo");
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="pick one way in structured activities", dependsOnMethods={"forEach"})
    private void pickOneWay() throws Exception {
        this.dealDeck();
        this.pickDiamond();
    }

    private void dealDeck() throws Exception {
        String payload = "<pic:dealDeck xmlns:pic=\"http://www.stark.com/PickService\"><pic:Deck>one</pic:Deck></pic:dealDeck>";
        String operation = "dealDeck";
        String serviceName = "PickService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add(">one<");
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    private void pickDiamond() throws Exception {
        String payload = "<pic:pickDiamond xmlns:pic=\"http://www.stark.com/PickService\"><pic:Deck>one</pic:Deck></pic:pickDiamond>";
        String operation = "pickDiamond";
        String serviceName = "PickService";
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, new ArrayList(), false);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestFlowLinks");
        this.bpelPackageManagementClient.undeployBPEL("TestForEach");
        this.bpelPackageManagementClient.undeployBPEL("TestPickOneWay");
        this.loginLogoutClient.logout();
    }
}

