/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELTestCaseMisc
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELTestCaseMisc.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("Async-Server");
        this.uploadBpelForTest("Async-Client");
        this.uploadBpelForTest("TestCorrelationWithAttribute");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "TestCorrelationWithAttribute");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="Async BPEL sample test case")
    public void testAsyncBPELSample() throws Exception {
        String payload = "<p:ClientRequest xmlns:p=\"urn:ode-apache-org:example:async:client\">\n      <p:id>1</p:id>\n      <p:input>2</p:input>\n   </p:ClientRequest>";
        String operation = "process";
        String serviceName = "ClientService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("Server says 2");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="Correlation with attribute sample test case")
    public void testCorrelationWithAttribute() throws Exception {
        String payload = " <p:TestCorrelationWithAttributeRequest xmlns:p=\"http://wso2.org/bps/sample\">\n      <!--Exactly 1 occurrence-->\n      <input xmlns=\"http://wso2.org/bps/sample\">99ee992</input>\n   </p:TestCorrelationWithAttributeRequest>";
        String operation = "process";
        String serviceName = "TestCorrelationWithAttribute";
        List expectedOutput = Collections.emptyList();
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, false);
        Thread.sleep(2000L);
        payload = " <p:CallbackOperation xmlns:p=\"http://www.example.org/callback/\">\n      <!--Exactly 1 occurrence-->\n      <xsd:in xmlns:xsd=\"http://www.example.org/callback/\">99ee992</xsd:in>\n   </p:CallbackOperation>";
        operation = "CallbackOperation";
        serviceName = "CallbackService";
        expectedOutput = new ArrayList();
        expectedOutput.add("99ee992");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("Async-Server");
        this.bpelPackageManagementClient.undeployBPEL("Async-Client");
        this.bpelPackageManagementClient.undeployBPEL("TestCorrelationWithAttribute");
        this.loginLogoutClient.logout();
    }
}

