/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.security;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import junit.framework.Assert;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.security.WSPasswordCallback;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.automation.core.ProductConstant;
import org.wso2.carbon.automation.core.RequestSender;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.utils.CarbonUtils;

public class SecurityWithServiceDescriptorTest
extends BPSMasterTest
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(SecurityWithServiceDescriptorTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("SecuredWithServiceDescriptorProcess");
    }

    @Test(groups={"wso2.bps", "wso2.bps.security"}, description="BPEL security test scenario - secure BPEL process with service.xml file")
    public void securityWithServiceDescriptorTest() throws Exception {
        String trustStore;
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "SWSDPService");
        ProductConstant.init();
        String securityPolicyPath = ProductConstant.SYSTEM_TEST_RESOURCE_LOCATION + "artifacts" + File.separator + "policy" + File.separator + "utpolicy.xml";
        String endpointHttpS = "https://localhost:9743/services/SWSDPService";
        String clientKey = trustStore = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "wso2carbon.jks";
        System.setProperty("javax.net.ssl.trustStore", trustStore);
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        System.out.println(CarbonUtils.getCarbonHome());
        ConfigurationContext ctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "client"), null);
        ServiceClient sc = new ServiceClient(ctx, null);
        sc.engageModule("addressing");
        sc.engageModule("rampart");
        Options opts = new Options();
        opts.setTo(new EndpointReference(endpointHttpS));
        log.info((Object)endpointHttpS);
        opts.setAction("urn:swsdp");
        log.info((Object)("SecurityPolicyPath " + securityPolicyPath));
        opts.setProperty("rampartPolicy", (Object)SecurityWithServiceDescriptorTest.loadPolicy(securityPolicyPath, clientKey, "admin"));
        sc.setOptions(opts);
        OMElement result = sc.sendReceive(AXIOMUtil.stringToOM((String)"<p:swsdp xmlns:p=\"http://wso2.org/bpel/sample.wsdl\">\n      <TestPart>ww</TestPart>\n   </p:swsdp>"));
        log.info((Object)result.getFirstElement().getText());
        Assert.assertFalse((String)("Incorrect Test Result: " + result.toString()), (!result.toString().contains("ww World") ? 1 : 0) != 0);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("SecuredWithServiceDescriptorProcess");
        this.loginLogoutClient.logout();
    }

    private static Policy loadPolicy(String xmlPath, String clientKey, String userName) throws Exception {
        StAXOMBuilder builder = new StAXOMBuilder(xmlPath);
        Policy policy = PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
        RampartConfig rc = new RampartConfig();
        rc.setUser(userName);
        rc.setUserCertAlias("wso2carbon");
        rc.setEncryptionUser("wso2carbon");
        rc.setPwCbClass(SecurityWithServiceDescriptorTest.class.getName());
        CryptoConfig sigCryptoConfig = new CryptoConfig();
        sigCryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
        Properties prop1 = new Properties();
        prop1.put("org.apache.ws.security.crypto.merlin.keystore.type", "JKS");
        prop1.put("org.apache.ws.security.crypto.merlin.file", clientKey);
        prop1.put("org.apache.ws.security.crypto.merlin.keystore.password", "wso2carbon");
        sigCryptoConfig.setProp(prop1);
        CryptoConfig encrCryptoConfig = new CryptoConfig();
        encrCryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
        Properties prop2 = new Properties();
        prop2.put("org.apache.ws.security.crypto.merlin.keystore.type", "JKS");
        prop2.put("org.apache.ws.security.crypto.merlin.file", clientKey);
        prop2.put("org.apache.ws.security.crypto.merlin.keystore.password", "wso2carbon");
        encrCryptoConfig.setProp(prop2);
        rc.setSigCryptoConfig(sigCryptoConfig);
        rc.setEncrCryptoConfig(encrCryptoConfig);
        policy.addAssertion((Assertion)rc);
        return policy;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        WSPasswordCallback pwcb = (WSPasswordCallback)callbacks[0];
        String id = pwcb.getIdentifier();
        int usage = pwcb.getUsage();
        if (usage == 2) {
            if ("admin".equals(id)) {
                pwcb.setPassword("admin");
            } else if ("admin@wso2.com".equals(id)) {
                pwcb.setPassword("admin123");
            }
        } else if ((usage == 3 || usage == 1) && "wso2carbon".equals(id)) {
            pwcb.setPassword("wso2carbon");
        }
    }
}

