/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.stucturedactivities;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedInstanceList;

public class BpelStructActionForEachTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelStructActionForEachTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestForEach");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "ForEachService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.structures"}, description="Deploys Bpel with Flow", priority=1)
    public void runSuccessCase() throws Exception, RemoteException {
        int instanceCount = 0;
        String processID = this.bpelProcessManagementClient.getProcessId("ForEach");
        PaginatedInstanceList instanceList = new PaginatedInstanceList();
        instanceList = this.bpelInstanceManagementClient.filterPageInstances(processID);
        if (instanceList.getInstance() != null) {
            instanceCount = instanceList.getInstance().length;
        }
        if (!processID.isEmpty()) {
            try {
                this.forEachRequest();
                Thread.sleep(5000L);
                if (instanceCount >= this.bpelInstanceManagementClient.filterPageInstances(processID).getInstance().length) {
                    Assert.fail((String)"Instance is not created for the request");
                }
            }
            catch (InterruptedException e) {
                log.error((Object)("Process management failed" + e));
                Assert.fail((String)("Process management failed" + e));
            }
            this.bpelInstanceManagementClient.clearInstancesOfProcess(processID);
        }
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestForEach");
        this.loginLogoutClient.logout();
    }

    public void forEachRequest() throws Exception {
        String payload = "<input xmlns=\"http://www.example.org/jms\">in</input>";
        String operation = "start";
        String serviceName = "ForEachService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("123");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }
}

