/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.stucturedactivities;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedInstanceList;

public class BpelStructActionWhileTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelStructActionWhileTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws InterruptedException, RemoteException, MalformedURLException, PackageManagementException, LoginAuthenticationExceptionException, Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestWhile");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "TestWhileService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.structures"}, description="Deploys TestWhile with activity", priority=0)
    public void runSuccessCase() throws Exception {
        int instanceCount = 0;
        String processID = this.bpelProcessManagementClient.getProcessId("TestWhile");
        PaginatedInstanceList instanceList = new PaginatedInstanceList();
        instanceList = this.bpelInstanceManagementClient.filterPageInstances(processID);
        if (instanceList.getInstance() != null) {
            instanceCount = instanceList.getInstance().length;
        }
        if (!processID.isEmpty()) {
            try {
                this.whileRequest();
                Thread.sleep(5000L);
                if (instanceCount >= this.bpelInstanceManagementClient.filterPageInstances(processID).getInstance().length) {
                    Assert.fail((String)"Instance is not created for the request");
                }
            }
            catch (InterruptedException e) {
                log.error((Object)("Process management failed" + e));
                Assert.fail((String)("Process management failed" + e));
            }
            this.bpelInstanceManagementClient.clearInstancesOfProcess(processID);
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("TestWhile");
        this.loginLogoutClient.logout();
    }

    public void whileRequest() throws Exception {
        String payload = " <p:TestWhileRequest xmlns:p=\"http://wso2.org/bps/samples/testWhile\">\n      <!--Exactly 1 occurrence-->\n      <input xmlns=\"http://wso2.org/bps/samples/testWhile\">22.2</input>\n   </p:TestWhileRequest>";
        String operation = "process";
        String serviceName = "TestWhileService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add("32.2");
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }
}

