/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.bpelactivities;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;

public class BPELRPCPartnerInvocationTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BPELRPCPartnerInvocationTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true, groups={"wso2.bps.bpelactivities"})
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("RPCServiceProcess");
        this.uploadBpelForTest("RPCClientProcess");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "RPCClientProcessService");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "RPCServiceProcessService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.bpelactivities"}, description="invoke RPC client process")
    private void invokeRPCClientProcess() throws Exception {
        String payload = "<rpc:RPCClientProcessRequest xmlns:rpc=\"http://wso2.org/bps/rpcclient\"><rpc:input>Hello</rpc:input></rpc:RPCClientProcessRequest>";
        String operation = "hello";
        String serviceName = "RPCClientProcessService";
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.add(">Hello World<");
        log.info((Object)("Service: " + this.backEndUrl + serviceName));
        this.requestSender.sendRequest(this.backEndUrl + serviceName, operation, payload, 1, expectedOutput, true);
    }

    @AfterClass(alwaysRun=true)
    public void removeArtifacts() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("RPCServiceProcess");
        this.bpelPackageManagementClient.undeployBPEL("RPCClientProcess");
        this.loginLogoutClient.logout();
    }
}

