/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.stucturedactivities;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.bpel.stub.mgt.InstanceManagementException;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.ProcessManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.LimitedInstanceInfoType;
import org.wso2.carbon.bpel.stub.mgt.types.PaginatedInstanceList;

public class BpelStructActionPickClientTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelStructActionPickClientTest.class);
    LimitedInstanceInfoType instanceInfo = null;
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    RequestSender requestSender;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws InterruptedException, RemoteException, MalformedURLException, PackageManagementException, LoginAuthenticationExceptionException, Exception {
        this.setEnvironment();
        this.uploadBpelForTest("TestPickOneWay");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "PickService");
        log.info((Object)"TestPickOneWay");
    }

    @Test(groups={"wso2.bps", "wso2.bps.structures"}, description="Deploys Bpel with If activity", priority=2)
    public void runSuccessCase() throws InstanceManagementException, RemoteException, ProcessManagementException, XMLStreamException {
        int instanceCount = 0;
        String processID = this.bpelProcessManagementClient.getProcessId("PickProcess");
        PaginatedInstanceList instanceList = new PaginatedInstanceList();
        instanceList = this.bpelInstanceManagementClient.filterPageInstances(processID);
        if (instanceList.getInstance() != null) {
            instanceCount = instanceList.getInstance().length;
        }
        if (!processID.isEmpty()) {
            try {
                this.pickRequest();
                Thread.sleep(5000L);
                if (instanceCount >= this.bpelInstanceManagementClient.filterPageInstances(processID).getInstance().length) {
                    Assert.fail((String)"Instance is not created for the request");
                }
            }
            catch (InterruptedException e) {
                log.error((Object)("Process management failed" + e));
                Assert.fail((String)("Process management failed" + e));
            }
            this.bpelInstanceManagementClient.clearInstancesOfProcess(processID);
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.loginLogoutClient.logout();
    }

    private void pickRequest() throws AxisFault, XMLStreamException {
        String payload = " <p:dealDeck xmlns:p=\"http://www.stark.com/PickService\">\n      <!--Exactly 1 occurrence-->\n      <xsd:Deck xmlns:xsd=\"http://www.stark.com/PickService\">10</xsd:Deck>\n   </p:dealDeck>";
        String operation = "dealDeck";
        String serviceName = "PickService";
        EndpointReference epr = new EndpointReference(this.backEndUrl + "PickService" + "/" + "dealDeck");
        RequestSender.sendRequest((String)payload, (EndpointReference)epr);
    }
}

