/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.bps.integration.tests.bpel.upload;

import java.io.File;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.bps.integration.common.clients.bpel.BpelInstanceManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelPackageManagementClient;
import org.wso2.bps.integration.common.clients.bpel.BpelProcessManagementClient;
import org.wso2.bps.integration.common.utils.BPSMasterTest;
import org.wso2.bps.integration.common.utils.RequestSender;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.bpel.stub.mgt.PackageManagementException;
import org.wso2.carbon.bpel.stub.mgt.ProcessManagementException;
import org.wso2.carbon.bpel.stub.mgt.types.ProcessStatus;

public class BpelVersioningTest
extends BPSMasterTest {
    private static final Log log = LogFactory.getLog(BpelVersioningTest.class);
    BpelPackageManagementClient bpelPackageManagementClient;
    BpelProcessManagementClient bpelProcessManagementClient;
    BpelInstanceManagementClient bpelInstanceManagementClient;
    private RequestSender requestSender;
    private LinkedList<String> activeStatus;

    public void setEnvironment() throws Exception {
        this.init();
        this.bpelPackageManagementClient = new BpelPackageManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelProcessManagementClient = new BpelProcessManagementClient(this.backEndUrl, this.sessionCookie);
        this.bpelInstanceManagementClient = new BpelInstanceManagementClient(this.backEndUrl, this.sessionCookie);
        this.requestSender = new RequestSender();
    }

    @BeforeClass(alwaysRun=true)
    public void deployArtifact() throws Exception {
        this.setEnvironment();
        this.uploadBpelForTest("HelloWorld2");
        this.requestSender.waitForProcessDeployment(this.backEndUrl + "HelloService");
    }

    @Test(groups={"wso2.bps", "wso2.bps.deployment"}, description="Tests uploading Bpel Service with In memory", singleThreaded=true)
    public void getVersion() throws RemoteException, XMLStreamException, InterruptedException, ProcessManagementException {
        Thread.sleep(5000L);
        List processBefore = this.bpelProcessManagementClient.getProcessInfoList("HelloWorld2");
        this.activeStatus = new LinkedList();
        for (String processid : processBefore) {
            if (!this.bpelProcessManagementClient.getStatus(processid).equals("ACTIVE")) continue;
            this.activeStatus.add(processid);
        }
        this.sendRequest();
    }

    private void sendRequest() throws XMLStreamException, AxisFault {
        String payLoad = " <p:hello xmlns:p=\"http://ode/bpel/unit-test.wsdl\">\n      <!--Exactly 1 occurrence--><TestPart>test</TestPart>\n   </p:hello>";
        String operation = "hello";
        String serviceName = "HelloService";
        String expectedBefore = "World";
        String expectedAfter = "World-Version";
        this.requestSender.assertRequest(this.backEndUrl + serviceName, operation, payLoad, 1, expectedBefore, true);
    }

    @Test(groups={"wso2.bps", "wso2.bps.deployment"}, description="Tests uploading BPEL process in-memory setting", dependsOnMethods={"getVersion"})
    public void checkVersion() throws InterruptedException, XMLStreamException, RemoteException, ProcessManagementException, PackageManagementException {
        String artifactLocation = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "bpel" + File.separator + "VersioningSamples";
        this.uploadBpelForTest("HelloWorld2", artifactLocation);
        List processAfter = null;
        for (int a = 0; a <= 10; ++a) {
            Thread.sleep(5000L);
            processAfter = this.bpelProcessManagementClient.getProcessInfoList("HelloWorld2");
            if (this.bpelProcessManagementClient.getStatus(this.activeStatus.get(0)).equals(ProcessStatus.RETIRED.toString())) break;
        }
        for (String process : this.activeStatus) {
            Assert.assertTrue((boolean)this.bpelProcessManagementClient.getStatus(process).equals(ProcessStatus.RETIRED.toString()), (String)("Versioning failed : Previous Version " + process + "is still active"));
        }
        for (String processInfo : processAfter) {
            if (!this.bpelProcessManagementClient.getStatus(processInfo).equals("ACTIVE")) continue;
            for (String process : this.activeStatus) {
                Assert.assertFalse((boolean)process.equals(processInfo), (String)("Versioning failed : Previous Version " + processInfo + "is still active"));
            }
        }
        this.sendRequest();
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws PackageManagementException, InterruptedException, RemoteException, LogoutAuthenticationExceptionException {
        this.bpelPackageManagementClient.undeployBPEL("HelloWorld2");
        this.loginLogoutClient.logout();
    }
}

